/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.bpmn.behavior.MappingExecutionContext;
import org.activiti.engine.impl.bpmn.behavior.VariablesCalculator;
import org.activiti.runtime.api.impl.CompositeVariableExpressionEvaluator;
import org.activiti.runtime.api.impl.ExpressionResolver;
import org.activiti.runtime.api.impl.SimpleMapExpressionEvaluator;
import org.activiti.runtime.api.impl.VariableScopeExpressionEvaluator;
import org.activiti.spring.process.ProcessExtensionService;
import org.activiti.spring.process.model.ConstantDefinition;
import org.activiti.spring.process.model.Extension;
import org.activiti.spring.process.model.Mapping;
import org.activiti.spring.process.model.ProcessConstantsMapping;
import org.activiti.spring.process.model.ProcessVariablesMapping;

public class ExtensionsVariablesMappingProvider
implements VariablesCalculator {
    private ProcessExtensionService processExtensionService;
    private ExpressionResolver expressionResolver;

    public ExtensionsVariablesMappingProvider(ProcessExtensionService processExtensionService, ExpressionResolver expressionResolver) {
        this.processExtensionService = processExtensionService;
        this.expressionResolver = expressionResolver;
    }

    protected Optional<Object> calculateMappedValue(Mapping inputMapping, DelegateExecution execution, Extension extensions) {
        if (inputMapping != null) {
            String name;
            if (Mapping.SourceMappingType.VALUE.equals((Object)inputMapping.getType())) {
                return Optional.of(inputMapping.getValue());
            }
            if (Mapping.SourceMappingType.VARIABLE.equals((Object)inputMapping.getType()) && this.isTargetProcessVariableDefined(extensions, execution, name = inputMapping.getValue().toString())) {
                return Optional.ofNullable(execution.getVariable(name));
            }
        }
        return Optional.empty();
    }

    public Map<String, Object> calculateInputVariables(DelegateExecution execution) {
        Extension extensions = this.processExtensionService.getExtensionsForId(execution.getProcessDefinitionId());
        Map<String, Object> constants = this.calculateConstants(execution, extensions);
        if (!extensions.hasMapping(execution.getCurrentActivityId())) {
            return constants;
        }
        if (extensions.shouldMapAllInputs(execution.getCurrentActivityId())) {
            HashMap<String, Object> variables = new HashMap<String, Object>(constants);
            variables.putAll(execution.getVariables());
            return variables;
        }
        Map<String, Object> inboundVariables = this.calculateInputVariables(execution, extensions);
        inboundVariables = this.expressionResolver.resolveExpressionsMap(new VariableScopeExpressionEvaluator((VariableScope)execution), inboundVariables);
        inboundVariables.putAll(constants);
        return inboundVariables;
    }

    private Map<String, Object> calculateConstants(DelegateExecution execution, Extension extensions) {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        ProcessConstantsMapping processConstantsMapping = extensions.getConstantForFlowElement(execution.getCurrentActivityId());
        for (Map.Entry mapping : processConstantsMapping.entrySet()) {
            constants.put((String)mapping.getKey(), ((ConstantDefinition)mapping.getValue()).getValue());
        }
        return constants;
    }

    private Map<String, Object> calculateInputVariables(DelegateExecution execution, Extension extensions) {
        HashMap<String, Object> inboundVariables = new HashMap<String, Object>();
        ProcessVariablesMapping processVariablesMapping = extensions.getMappingForFlowElement(execution.getCurrentActivityId());
        Map inputMappings = processVariablesMapping.getInputs();
        for (Map.Entry mapping : inputMappings.entrySet()) {
            Optional<Object> mappedValue = this.calculateMappedValue((Mapping)mapping.getValue(), execution, extensions);
            mappedValue.ifPresent(value -> inboundVariables.put((String)mapping.getKey(), value));
        }
        return inboundVariables;
    }

    private Optional<Object> calculateOutPutMappedValue(Mapping mapping, Map<String, Object> currentContextVariables) {
        if (mapping != null) {
            if (Mapping.SourceMappingType.VALUE.equals((Object)mapping.getType())) {
                return Optional.of(mapping.getValue());
            }
            if (Mapping.SourceMappingType.VARIABLE.equals((Object)mapping.getType())) {
                String name = mapping.getValue().toString();
                return currentContextVariables != null ? Optional.ofNullable(currentContextVariables.get(name)) : Optional.empty();
            }
        }
        return Optional.empty();
    }

    public Map<String, Object> calculateOutPutVariables(MappingExecutionContext mappingExecutionContext, Map<String, Object> availableVariables) {
        Extension extensions = this.processExtensionService.getExtensionsForId(mappingExecutionContext.getProcessDefinitionId());
        if (!extensions.hasMapping(mappingExecutionContext.getActivityId())) {
            return Collections.emptyMap();
        }
        if (this.expressionResolver.containsExpression(availableVariables)) {
            throw new ActivitiIllegalArgumentException("Expressions are not allowed as variable values in the output mapping");
        }
        if (extensions.shouldMapAllOutputs(mappingExecutionContext.getActivityId())) {
            return availableVariables != null ? new HashMap<String, Object>(availableVariables) : Collections.emptyMap();
        }
        return this.calculateOutPutVariables(mappingExecutionContext, extensions, availableVariables);
    }

    private Map<String, Object> calculateOutPutVariables(MappingExecutionContext mappingExecutionContext, Extension extensions, Map<String, Object> availableVariables) {
        HashMap<String, Object> outboundVariables = new HashMap<String, Object>();
        ProcessVariablesMapping processVariablesMapping = extensions.getMappingForFlowElement(mappingExecutionContext.getActivityId());
        Map outputMappings = processVariablesMapping.getOutputs();
        for (Map.Entry mapping : outputMappings.entrySet()) {
            String name = (String)mapping.getKey();
            if (!this.isTargetProcessVariableDefined(extensions, mappingExecutionContext.getExecution(), name)) continue;
            this.calculateOutPutMappedValue((Mapping)mapping.getValue(), availableVariables).ifPresent(value -> outboundVariables.put((String)mapping.getKey(), value));
        }
        return this.resolveExpressions(mappingExecutionContext, availableVariables, outboundVariables);
    }

    private Map<String, Object> resolveExpressions(MappingExecutionContext mappingExecutionContext, Map<String, Object> availableVariables, Map<String, Object> outboundVariables) {
        if (mappingExecutionContext.hasExecution()) {
            return this.resolveExecutionExpressions(mappingExecutionContext, availableVariables, outboundVariables);
        }
        return this.expressionResolver.resolveExpressionsMap(new SimpleMapExpressionEvaluator(availableVariables), outboundVariables);
    }

    private Map<String, Object> resolveExecutionExpressions(MappingExecutionContext mappingExecutionContext, Map<String, Object> availableVariables, Map<String, Object> outboundVariables) {
        if (availableVariables != null && !availableVariables.isEmpty()) {
            return this.expressionResolver.resolveExpressionsMap(new CompositeVariableExpressionEvaluator(new SimpleMapExpressionEvaluator(availableVariables), new VariableScopeExpressionEvaluator((VariableScope)mappingExecutionContext.getExecution())), outboundVariables);
        }
        return this.expressionResolver.resolveExpressionsMap(new VariableScopeExpressionEvaluator((VariableScope)mappingExecutionContext.getExecution()), outboundVariables);
    }

    private boolean isTargetProcessVariableDefined(Extension extensions, DelegateExecution execution, String variableName) {
        return extensions.getPropertyByName(variableName) != null || execution != null && execution.getVariable(variableName) != null;
    }
}

