/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.interceptor.DelegateInterceptor;
import org.activiti.runtime.api.impl.ExpressionEvaluator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionResolver {
    private static final TypeReference<Map<String, ?>> MAP_STRING_OBJECT_TYPE = new TypeReference<Map<String, ?>>(){};
    private final Logger logger = LoggerFactory.getLogger(ExpressionResolver.class);
    private static final String EXPRESSION_PATTERN_STRING = "([\\$]\\{([^\\}]*)\\})";
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("([\\$]\\{([^\\}]*)\\})");
    private static final int EXPRESSION_KEY_INDEX = 1;
    private ObjectMapper mapper;
    private final DelegateInterceptor delegateInterceptor;
    private ExpressionManager expressionManager;

    public ExpressionResolver(ExpressionManager expressionManager, ObjectMapper mapper, DelegateInterceptor delegateInterceptor) {
        this.expressionManager = expressionManager;
        this.mapper = mapper;
        this.delegateInterceptor = delegateInterceptor;
    }

    private Object resolveExpressions(ExpressionEvaluator expressionEvaluator, Object value) {
        if (value instanceof String) {
            return this.resolveExpressionsString(expressionEvaluator, (String)value);
        }
        if (value instanceof ObjectNode) {
            return this.resolveExpressionsMap(expressionEvaluator, (Map)this.mapper.convertValue(value, MAP_STRING_OBJECT_TYPE));
        }
        if (value instanceof Map) {
            return this.resolveExpressionsMap(expressionEvaluator, (Map)value);
        }
        if (value instanceof List) {
            return this.resolveExpressionsList(expressionEvaluator, (List)value);
        }
        return value;
    }

    private List<Object> resolveExpressionsList(ExpressionEvaluator expressionEvaluator, List<?> sourceList) {
        LinkedList<Object> result = new LinkedList<Object>();
        sourceList.forEach(value -> result.add(this.resolveExpressions(expressionEvaluator, value)));
        return result;
    }

    public Map<String, Object> resolveExpressionsMap(ExpressionEvaluator expressionEvaluator, Map<String, ?> sourceMap) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        sourceMap.forEach((key, value) -> result.put((String)key, this.resolveExpressions(expressionEvaluator, value)));
        return result;
    }

    private Object resolveExpressionsString(ExpressionEvaluator expressionEvaluator, String sourceString) {
        if (StringUtils.isBlank((CharSequence)sourceString)) {
            return sourceString;
        }
        if (sourceString.matches(EXPRESSION_PATTERN_STRING)) {
            return this.resolveObjectPlaceHolder(expressionEvaluator, sourceString);
        }
        return this.resolveInStringPlaceHolder(expressionEvaluator, sourceString);
    }

    private Object resolveObjectPlaceHolder(ExpressionEvaluator expressionEvaluator, String sourceString) {
        try {
            return expressionEvaluator.evaluate(this.expressionManager.createExpression(sourceString), this.expressionManager, this.delegateInterceptor);
        }
        catch (Exception e) {
            this.logger.warn("Unable to resolve expression in variables", (Throwable)e);
            return null;
        }
    }

    private String resolveInStringPlaceHolder(ExpressionEvaluator expressionEvaluator, String sourceString) {
        Matcher matcher = EXPRESSION_PATTERN.matcher(sourceString);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String expressionKey = matcher.group(1);
            Expression expression = this.expressionManager.createExpression(expressionKey);
            try {
                Object value = expressionEvaluator.evaluate(expression, this.expressionManager, this.delegateInterceptor);
                matcher.appendReplacement(sb, Objects.toString(value));
            }
            catch (Exception e) {
                this.logger.warn("Unable to resolve expression in variables", (Throwable)e);
                matcher.appendReplacement(sb, "");
            }
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public boolean containsExpression(Object source) {
        if (source == null) {
            return false;
        }
        if (source instanceof String) {
            return this.containsExpressionString((String)source);
        }
        if (source instanceof ObjectNode) {
            return this.containsExpressionMap((Map)this.mapper.convertValue(source, MAP_STRING_OBJECT_TYPE));
        }
        if (source instanceof Map) {
            return this.containsExpressionMap((Map)source);
        }
        if (source instanceof List) {
            return this.containsExpressionList((List)source);
        }
        return false;
    }

    private boolean containsExpressionString(String sourceString) {
        return EXPRESSION_PATTERN.matcher(sourceString).find();
    }

    private boolean containsExpressionMap(Map<String, ?> source) {
        for (Map.Entry<String, ?> entry : source.entrySet()) {
            if (!this.containsExpression(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean containsExpressionList(List<?> source) {
        for (Object item : source) {
            if (!this.containsExpression(item)) continue;
            return true;
        }
        return false;
    }
}

