/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.impl;

import java.util.Map;
import java.util.Objects;
import org.activiti.api.process.model.payloads.ReceiveMessagePayload;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ManagementService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.EventSubscriptionQueryImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.runtime.api.message.ReceiveMessagePayloadEventListener;

public class RuntimeReceiveMessagePayloadEventListener
implements ReceiveMessagePayloadEventListener {
    private final RuntimeService runtimeService;
    private final ManagementService managementService;

    public RuntimeReceiveMessagePayloadEventListener(RuntimeService runtimeService, ManagementService managementService) {
        this.runtimeService = runtimeService;
        this.managementService = managementService;
    }

    @Override
    public void receiveMessage(ReceiveMessagePayload messagePayload) {
        String correlationKey;
        String messageName = messagePayload.getName();
        EventSubscriptionEntity subscription = (EventSubscriptionEntity)this.managementService.executeCommand((Command)new FindMessageEventSubscription(messageName, correlationKey = messagePayload.getCorrelationKey()));
        if (subscription == null || !Objects.equals(correlationKey, subscription.getConfiguration())) {
            throw new ActivitiObjectNotFoundException("Message subscription name '" + messageName + "' with correlation key '" + correlationKey + "' not found.");
        }
        Map variables = messagePayload.getVariables();
        String executionId = subscription.getExecutionId();
        this.runtimeService.messageEventReceived(messageName, executionId, variables);
    }

    static class FindMessageEventSubscription
    implements Command<EventSubscriptionEntity> {
        private final String messageName;
        private final String correlationKey;

        public FindMessageEventSubscription(String messageName, String correlationKey) {
            this.messageName = messageName;
            this.correlationKey = correlationKey;
        }

        public EventSubscriptionEntity execute(CommandContext commandContext) {
            return (EventSubscriptionEntity)new EventSubscriptionQueryImpl(commandContext).eventType("message").eventName(this.messageName).configuration(this.correlationKey).singleResult();
        }
    }
}

