/*
 * Copyright 2010-2025 Hyland Software, Inc. and its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.engine.impl.cmd;

import java.util.Collection;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

/**


 */
public class RemoveExecutionVariablesCmd extends NeedsActiveExecutionCmd<Void> {

    private static final long serialVersionUID = 1L;

    private Collection<String> variableNames;
    private boolean isLocal;

    public RemoveExecutionVariablesCmd(String executionId, Collection<String> variableNames, boolean isLocal) {
        super(executionId);
        this.variableNames = variableNames;
        this.isLocal = isLocal;
    }

    protected Void execute(CommandContext commandContext, ExecutionEntity execution) {
        if (isLocal) {
            execution.removeVariablesLocal(variableNames);
        } else {
            execution.removeVariables(variableNames);
        }

        return null;
    }

    @Override
    protected String getSuspendedExceptionMessage() {
        return "Cannot remove variables because execution '" + executionId + "' is suspended";
    }
}
