/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.deployer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.bpmn.deployer.ParsedDeployment;
import org.activiti.engine.impl.bpmn.deployer.ResourceNameUtil;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.BpmnParser;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.ResourceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedDeploymentBuilder {
    private static final Logger log = LoggerFactory.getLogger(ParsedDeploymentBuilder.class);
    protected DeploymentEntity deployment;
    protected BpmnParser bpmnParser;
    protected Map<String, Object> deploymentSettings;

    public ParsedDeploymentBuilder(DeploymentEntity deployment, BpmnParser bpmnParser, Map<String, Object> deploymentSettings) {
        this.deployment = deployment;
        this.bpmnParser = bpmnParser;
        this.deploymentSettings = deploymentSettings;
    }

    public ParsedDeployment build() {
        ArrayList<ProcessDefinitionEntity> processDefinitions = new ArrayList<ProcessDefinitionEntity>();
        LinkedHashMap<ProcessDefinitionEntity, BpmnParse> processDefinitionsToBpmnParseMap = new LinkedHashMap<ProcessDefinitionEntity, BpmnParse>();
        LinkedHashMap<ProcessDefinitionEntity, ResourceEntity> processDefinitionsToResourceMap = new LinkedHashMap<ProcessDefinitionEntity, ResourceEntity>();
        for (ResourceEntity resource : this.deployment.getResources().values()) {
            if (!this.isBpmnResource(resource.getName()) || this.deploymentSettings != null && !this.mayBeContainsProcessDefinitionResourceName(resource.getName())) continue;
            log.debug("Processing BPMN resource {}", (Object)resource.getName());
            BpmnParse parse = this.createBpmnParseFromResource(resource);
            for (ProcessDefinitionEntity processDefinition : parse.getProcessDefinitions()) {
                processDefinitions.add(processDefinition);
                processDefinitionsToBpmnParseMap.put(processDefinition, parse);
                processDefinitionsToResourceMap.put(processDefinition, resource);
            }
        }
        return new ParsedDeployment(this.deployment, processDefinitions, processDefinitionsToBpmnParseMap, processDefinitionsToResourceMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean mayBeContainsProcessDefinitionResourceName(String resourceName) {
        if (!this.deploymentSettings.containsKey("resourceNames")) return true;
        if (!Optional.of(this.deploymentSettings.get("resourceNames")).filter(List.class::isInstance).map(List.class::cast).filter(it -> it.contains(resourceName)).isPresent()) return false;
        return true;
    }

    protected BpmnParse createBpmnParseFromResource(ResourceEntity resource) {
        BpmnParse bpmnParse;
        String resourceName = resource.getName();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(resource.getBytes());
        try {
            BpmnParse bpmnParse2 = this.bpmnParser.createParse().sourceInputStream(inputStream).setSourceSystemId(resourceName).deployment(this.deployment).name(resourceName);
            if (this.deploymentSettings != null) {
                if (this.deploymentSettings.containsKey("isBpmn20XsdValidationEnabled")) {
                    bpmnParse2.setValidateSchema((Boolean)this.deploymentSettings.get("isBpmn20XsdValidationEnabled"));
                }
                if (this.deploymentSettings.containsKey("isProcessValidationEnabled")) {
                    bpmnParse2.setValidateProcess((Boolean)this.deploymentSettings.get("isProcessValidationEnabled"));
                }
            } else {
                bpmnParse2.setValidateSchema(false);
                bpmnParse2.setValidateProcess(false);
            }
            bpmnParse2.execute();
            bpmnParse = bpmnParse2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ActivitiException(e.getMessage(), e);
            }
        }
        inputStream.close();
        return bpmnParse;
    }

    protected boolean isBpmnResource(String resourceName) {
        for (String suffix : ResourceNameUtil.BPMN_RESOURCE_SUFFIXES) {
            if (!resourceName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }
}

