/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process;

import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.spring.process.ProcessExtensionRepository;
import org.activiti.spring.process.model.Extension;
import org.springframework.lang.NonNull;

public class ProcessExtensionService {
    private static final Extension EMPTY_EXTENSION = new Extension();
    private final ProcessExtensionRepository processExtensionRepository;

    public ProcessExtensionService(ProcessExtensionRepository processExtensionRepository) {
        this.processExtensionRepository = processExtensionRepository;
    }

    public boolean hasExtensionsFor(@NonNull ProcessDefinition processDefinition) {
        return this.hasExtensionsFor(processDefinition.getId());
    }

    public boolean hasExtensionsFor(@NonNull String processDefinitionId) {
        return this.processExtensionRepository.getExtensionsForId(processDefinitionId).isPresent();
    }

    public Extension getExtensionsFor(@NonNull ProcessDefinition processDefinition) {
        return this.getExtensionsForId(processDefinition.getId());
    }

    public Extension getExtensionsForId(@NonNull String processDefinitionId) {
        return this.processExtensionRepository.getExtensionsForId(processDefinitionId).orElse(EMPTY_EXTENSION);
    }
}

