/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring.process.variable.types;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.spring.process.variable.types.VariableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonObjectVariableType
extends VariableType {
    private static final Logger logger = LoggerFactory.getLogger(JsonObjectVariableType.class);
    private ObjectMapper objectMapper;

    public JsonObjectVariableType(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public void validate(Object var, List<ActivitiException> errors) {
        String message;
        if (!this.objectMapper.canSerialize(var.getClass())) {
            message = String.valueOf(var.getClass()) + " is not serializable as json";
            errors.add(new ActivitiException(message));
            logger.error(message);
        }
        if (!this.objectMapper.canDeserialize(this.objectMapper.constructType(var.getClass()))) {
            message = String.valueOf(var.getClass()) + " is not deserializable as json";
            errors.add(new ActivitiException(message));
            logger.error(message);
        }
    }
}

