/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.api.process.model.impl;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import org.activiti.api.model.shared.model.ApplicationElement;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.cloud.api.model.shared.impl.CloudRuntimeEntityImpl;
import org.activiti.cloud.api.process.model.CloudProcessInstance;

public class CloudProcessInstanceImpl
extends CloudRuntimeEntityImpl
implements CloudProcessInstance {
    private String id;
    private String name;
    private Date startDate;
    private String initiator;
    @Schema(description="The business key associated to the process instance. It could be useful to add a reference to external systems.", readOnly=true)
    private String businessKey;
    private ProcessInstance.ProcessInstanceStatus status;
    private String processDefinitionId;
    @Schema(description="It identifies uniquely the process. In the BPMN process definition file it is the id attribute of a process and in the Modeling application it is usually called as Process ID.")
    private String processDefinitionKey;
    private String parentId;
    private Integer processDefinitionVersion;
    private String processDefinitionName;
    private Date completedDate;
    private Date suspendedDate;

    public CloudProcessInstanceImpl() {
    }

    public CloudProcessInstanceImpl(ProcessInstance processInstance) {
        super((ApplicationElement)processInstance);
        this.id = processInstance.getId();
        this.name = processInstance.getName();
        this.startDate = processInstance.getStartDate();
        this.initiator = processInstance.getInitiator();
        this.businessKey = processInstance.getBusinessKey();
        this.status = processInstance.getStatus();
        this.processDefinitionId = processInstance.getProcessDefinitionId();
        this.processDefinitionKey = processInstance.getProcessDefinitionKey();
        this.parentId = processInstance.getParentId();
        this.processDefinitionVersion = processInstance.getProcessDefinitionVersion();
        this.processDefinitionName = processInstance.getProcessDefinitionName();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(Date completedDate) {
        this.completedDate = completedDate;
    }

    public Date getSuspendedDate() {
        return this.suspendedDate;
    }

    public void setSuspendedDate(Date suspendedDate) {
        this.suspendedDate = suspendedDate;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public ProcessInstance.ProcessInstanceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ProcessInstance.ProcessInstanceStatus status) {
        this.status = status;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }
}

