/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.error.attributes;

import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.activiti.cloud.common.error.attributes.ErrorAttributesCustomizer;

public class ErrorAttributesMessageSanitizer
implements ErrorAttributesCustomizer {
    public static final String MESSAGE = "message";
    public static final String ERROR_NOT_DISCLOSED_MESSAGE = "A technical error occurred. Additional information is not disclosed for security reasons.";
    public static final String[] TECHNICAL_INFO_BLACKLIST = new String[]{"java.", "javax.", "jakarta.", "java_cup.", "org.", "com.", "net.", "io.", "dev.", "de."};
    public static final Pattern VALIDATION_REGEX = ErrorAttributesMessageSanitizer.compileValidationRegex();

    @Override
    public Map<String, Object> customize(Map<String, Object> errorAttributes, Throwable error) {
        if (errorAttributes.containsKey(MESSAGE)) {
            String message = (String)errorAttributes.getOrDefault(MESSAGE, "");
            String censoredMessage = this.containsTechnicalInfo(message) ? ERROR_NOT_DISCLOSED_MESSAGE : message;
            errorAttributes.put(MESSAGE, censoredMessage);
        }
        return errorAttributes;
    }

    private boolean containsTechnicalInfo(String message) {
        return VALIDATION_REGEX.matcher(message).find();
    }

    private static Pattern compileValidationRegex() {
        String pipedBlacklist = Arrays.stream(TECHNICAL_INFO_BLACKLIST).map(s -> s.replaceAll("\\.", "")).collect(Collectors.joining("|"));
        String regex = "\\W(".concat(pipedBlacklist).concat(")\\.\\w");
        return Pattern.compile(regex);
    }
}

