/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.messaging;

import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.activiti.cloud.common.messaging.config.InputConverterFunction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="activiti.cloud.messaging")
@Validated
public class ActivitiCloudMessagingProperties {
    public static final String ACTIVITI_CLOUD_MESSAGING_PREFIX = "activiti.cloud.messaging";
    @NotNull
    private MessagingBroker broker = MessagingBroker.rabbitmq;
    @NotNull
    private Boolean partitioned = false;
    @NotNull
    @Positive
    private Integer partitionCount = 1;
    @NotNull
    @Min(value=0L)
    private @NotNull @Min(value=0L) Integer instanceIndex = 0;
    @NotEmpty
    @Size(min=1, max=1)
    private @NotEmpty @Size(min=1, max=1) String destinationSeparator = "_";
    private String destinationPrefix = "";
    private boolean destinationTransformersEnabled = false;
    private List<String> destinationTransformers = new ArrayList<String>();
    private String destinationIllegalCharsRegex = "[\\t\\s*#:]";
    private String destinationIllegalCharsReplacement = "-";
    private Map<String, DestinationProperties> destinations = new LinkedCaseInsensitiveMap();
    private Map<String, InputConverterFunction> inputConverters;
    private RabbitMqProperties rabbitmq = new RabbitMqProperties();

    ActivitiCloudMessagingProperties() {
    }

    public RabbitMqProperties getRabbitmq() {
        return this.rabbitmq;
    }

    public void setRabbitmq(RabbitMqProperties rabbitmq) {
        this.rabbitmq = rabbitmq;
    }

    public Boolean isPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(boolean partitioned) {
        this.partitioned = partitioned;
    }

    public Integer getPartitionCount() {
        return this.partitionCount;
    }

    public void setPartitionCount(Integer partitionCount) {
        this.partitionCount = partitionCount;
    }

    public Integer getInstanceIndex() {
        return this.instanceIndex;
    }

    public void setInstanceIndex(Integer instanceIndex) {
        this.instanceIndex = instanceIndex;
    }

    public String getDestinationSeparator() {
        return this.destinationSeparator;
    }

    public void setDestinationSeparator(String destinationSeparator) {
        this.destinationSeparator = destinationSeparator;
    }

    public String getDestinationPrefix() {
        return this.destinationPrefix;
    }

    public void setDestinationPrefix(String destinationPrefix) {
        this.destinationPrefix = destinationPrefix;
    }

    public Map<String, DestinationProperties> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Map<String, DestinationProperties> destinations) {
        this.destinations = destinations;
    }

    public boolean isDestinationTransformersEnabled() {
        return this.destinationTransformersEnabled;
    }

    public void setDestinationTransformersEnabled(boolean destinationTransformersEnabled) {
        this.destinationTransformersEnabled = destinationTransformersEnabled;
    }

    public String getDestinationIllegalCharsRegex() {
        return this.destinationIllegalCharsRegex;
    }

    public void setDestinationIllegalCharsRegex(String destinationIllegalCharsRegex) {
        this.destinationIllegalCharsRegex = destinationIllegalCharsRegex;
    }

    public String getDestinationIllegalCharsReplacement() {
        return this.destinationIllegalCharsReplacement;
    }

    public void setDestinationIllegalCharsReplacement(String destinationIllegalCharsReplacement) {
        this.destinationIllegalCharsReplacement = destinationIllegalCharsReplacement;
    }

    public Function<String, String> transformDestination() {
        return input -> {
            InputConverter<String> converter = new InputConverter<String>((String)input);
            for (String it : this.destinationTransformers) {
                InputConverterFunction func = Optional.ofNullable(this.inputConverters.get(it)).orElseThrow();
                converter = converter.convertBy(func);
            }
            return converter.pack();
        };
    }

    @Autowired
    public void configureInputConverters(@Lazy Map<String, InputConverterFunction> inputConverters) {
        this.inputConverters = new LinkedHashMap<String, InputConverterFunction>(inputConverters);
    }

    public List<String> getDestinationTransformers() {
        return this.destinationTransformers;
    }

    public void setDestinationTransformers(List<String> destinationTransformers) {
        this.destinationTransformers = destinationTransformers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivitiCloudMessagingProperties that = (ActivitiCloudMessagingProperties)o;
        return this.broker == that.broker && Objects.equals(this.partitioned, that.partitioned) && Objects.equals(this.partitionCount, that.partitionCount) && Objects.equals(this.instanceIndex, that.instanceIndex) && Objects.equals(this.destinationSeparator, that.destinationSeparator) && Objects.equals(this.destinationPrefix, that.destinationPrefix) && Objects.equals(this.destinations, that.destinations);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.broker, this.partitioned, this.partitionCount, this.instanceIndex, this.destinationSeparator, this.destinationPrefix, this.destinations});
    }

    public String toString() {
        return "ActivitiCloudMessagingProperties{broker=" + String.valueOf((Object)this.broker) + ", partitioned=" + this.partitioned + ", partitionCount=" + this.partitionCount + ", instanceIndex=" + this.instanceIndex + ", destinationSeparator='" + this.destinationSeparator + "', destinationPrefix='" + this.destinationPrefix + "', destinations=" + String.valueOf(this.destinations) + ", destinationIllegalCharsReplacement=" + this.destinationIllegalCharsReplacement + ", destinationIllegalCharsRegex=" + this.destinationIllegalCharsRegex + "}";
    }

    public static enum MessagingBroker {
        rabbitmq,
        kafka,
        aws;

    }

    public static class RabbitMqProperties {
        private Boolean missingAnonymousQueuesFatal;

        public Boolean getMissingAnonymousQueuesFatal() {
            return this.missingAnonymousQueuesFatal;
        }

        public void setMissingAnonymousQueuesFatal(Boolean missingAnonymousQueuesFatal) {
            this.missingAnonymousQueuesFatal = missingAnonymousQueuesFatal;
        }
    }

    static class InputConverter<T> {
        private final T data;

        public InputConverter(T data) {
            this.data = data;
        }

        public <U> InputConverter<U> convertBy(Function<T, U> function) {
            return new InputConverter<U>(function.apply(this.data));
        }

        public T pack() {
            return this.data;
        }
    }

    @Validated
    public static class DestinationProperties {
        private String name = "";
        private String scope;
        private String prefix;
        private String separator;

        DestinationProperties() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getSeparator() {
            return this.separator;
        }

        public void setSeparator(String separator) {
            this.separator = separator;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public String toString() {
            return "DestinationProperties{, name='" + this.name + "', scope='" + this.scope + "', prefix='" + this.prefix + "', separator='" + this.separator + "'}";
        }
    }
}

