/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.messaging.config;

import com.rabbitmq.client.ConnectionFactory;
import java.util.Optional;
import org.activiti.cloud.common.messaging.ActivitiCloudMessagingProperties;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.stream.config.ListenerContainerCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

@AutoConfiguration
@EnableConfigurationProperties(value={ActivitiCloudMessagingProperties.class})
@PropertySources(value={@PropertySource(value={"classpath:config/activiti-cloud-messaging.properties"}), @PropertySource(value={"file:config/activiti-cloud-messaging.properties"}, ignoreResourceNotFound=true)})
public class ActivitiCloudMessagingAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ConnectionFactory.class, MessageListenerContainer.class})
    static class ActivitiCloudMessagingRabbitConfiguration {
        ActivitiCloudMessagingRabbitConfiguration() {
        }

        @Bean
        ListenerContainerCustomizer<MessageListenerContainer> activitiRabbitMqMessageListenerContainerCustomizer(ActivitiCloudMessagingProperties activitiCloudMessagingProperties) {
            return (container, destinationName, group) -> {
                if (container instanceof AbstractMessageListenerContainer) {
                    AbstractMessageListenerContainer rabbitListenerContainer = (AbstractMessageListenerContainer)container;
                    if (group == null) {
                        Optional.ofNullable(activitiCloudMessagingProperties).map(ActivitiCloudMessagingProperties::getRabbitmq).map(ActivitiCloudMessagingProperties.RabbitMqProperties::getMissingAnonymousQueuesFatal).ifPresent(arg_0 -> ((AbstractMessageListenerContainer)rabbitListenerContainer).setMissingQueuesFatal(arg_0));
                    }
                }
            };
        }
    }
}

