/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.messaging.config;

import org.activiti.cloud.common.messaging.ActivitiCloudMessagingProperties;
import org.activiti.cloud.common.messaging.config.ActivitiMessagingDestinationTransformer;
import org.activiti.cloud.common.messaging.config.ActivitiMessagingDestinationsBeanPostProcessor;
import org.activiti.cloud.common.messaging.config.InputConverterFunction;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.stream.config.BinderFactoryAutoConfiguration;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;

@AutoConfiguration
@AutoConfigureBefore(value={BinderFactoryAutoConfiguration.class})
@ConditionalOnClass(value={BindingServiceProperties.class})
public class ActivitiMessagingDestinationsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ActivitiMessagingDestinationTransformer activitiMessagingDestinationTransformer(ActivitiCloudMessagingProperties messagingProperties) {
        return new ActivitiMessagingDestinationTransformer(messagingProperties);
    }

    @Bean
    public ActivitiMessagingDestinationsBeanPostProcessor activitiMessagingDestinationsBeanPostProcessor(ActivitiMessagingDestinationTransformer destinationTransformer) {
        return new ActivitiMessagingDestinationsBeanPostProcessor(destinationTransformer);
    }

    @Bean
    public InputConverterFunction toLowerCase() {
        return String::toLowerCase;
    }

    @Bean
    public InputConverterFunction escapeIllegalChars(@Lazy ActivitiCloudMessagingProperties messagingProperties) {
        return value -> value.replaceAll(messagingProperties.getDestinationIllegalCharsRegex(), messagingProperties.getDestinationIllegalCharsReplacement());
    }
}

