/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.messaging.config;

import java.util.Optional;
import org.activiti.cloud.common.messaging.config.ActivitiMessagingDestinationTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.core.Ordered;

public class ActivitiMessagingDestinationsBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(ActivitiMessagingDestinationsBeanPostProcessor.class);
    private final ActivitiMessagingDestinationTransformer destinationTransformer;

    public ActivitiMessagingDestinationsBeanPostProcessor(ActivitiMessagingDestinationTransformer destinationTransformer) {
        this.destinationTransformer = destinationTransformer;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (BindingServiceProperties.class.isInstance(bean)) {
            BindingServiceProperties bindingServiceProperties = (BindingServiceProperties)BindingServiceProperties.class.cast(bean);
            log.info("Post-processing messaging destinations for bean {} with name {}", bean, (Object)beanName);
            bindingServiceProperties.getBindings().forEach((bindingName, bindingProperties) -> {
                String source = Optional.ofNullable(bindingProperties.getDestination()).orElse((String)bindingName);
                String destination = this.destinationTransformer.apply(source);
                bindingProperties.setDestination(destination);
                log.warn("Configured destination '{}' for binding '{}'", (Object)destination, bindingName);
            });
        }
        return bean;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

