/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.messaging.config;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.activiti.cloud.common.messaging.config.AbstractFunctionalBindingConfiguration;
import org.activiti.cloud.common.messaging.config.FunctionAnnotationService;
import org.activiti.cloud.common.messaging.config.FunctionBindingPropertySource;
import org.activiti.cloud.common.messaging.functional.FunctionBinding;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.json.JacksonMapper;
import org.springframework.cloud.stream.config.BinderFactoryAutoConfiguration;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.function.FunctionConfiguration;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.integration.core.GenericHandler;
import org.springframework.integration.core.GenericSelector;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.StandardIntegrationFlow;
import org.springframework.integration.dsl.context.IntegrationFlowContext;
import org.springframework.integration.filter.ExpressionEvaluatingSelector;
import org.springframework.integration.handler.LoggingHandler;
import org.springframework.messaging.Message;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={BinderFactoryAutoConfiguration.class}, before={FunctionConfiguration.class})
@ConditionalOnClass(value={BindingServiceProperties.class})
public class FunctionBindingConfiguration
extends AbstractFunctionalBindingConfiguration {
    public static final String FUNCTION_BINDING_SELECTOR_DISCARD_FLOW = "functionBindingSelectorDiscardFlow";
    public static final String FUNCTION_BINDING_SELECTOR_DISCARD_CHANNEL = "functionBindingSelectorDiscardChannel";
    public static final String NULL_CHANNEL = "nullChannel";

    @Bean
    public BindingResolver bindingResolver(BindingServiceProperties bindingServiceProperties) {
        return destination -> Optional.ofNullable(bindingServiceProperties.getBindingDestination(destination)).orElse((String)destination);
    }

    @Bean
    public FunctionBindingPropertySource functionDefinitionPropertySource(ConfigurableApplicationContext applicationContext) {
        return new FunctionBindingPropertySource(applicationContext.getEnvironment());
    }

    @Bean
    public FunctionAnnotationService functionAnnotationService(DefaultListableBeanFactory beanFactory) {
        return new FunctionAnnotationService(beanFactory);
    }

    @Bean(value={"resolveExpression"})
    public Function<String, String> resolveExpression(ConfigurableApplicationContext applicationContext) {
        return value -> {
            BeanExpressionResolver resolver = applicationContext.getBeanFactory().getBeanExpressionResolver();
            BeanExpressionContext expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)applicationContext.getBeanFactory(), null);
            String resolvedValue = applicationContext.getBeanFactory().resolveEmbeddedValue(value);
            if (resolvedValue.startsWith("#{") && value.endsWith("}")) {
                resolvedValue = (String)resolver.evaluate(resolvedValue, expressionContext);
            }
            return resolvedValue;
        };
    }

    @Bean(name={"functionBindingSelectorDiscardFlow"})
    IntegrationFlow functionBindingSelectorDiscardFlow() {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from((String)FUNCTION_BINDING_SELECTOR_DISCARD_CHANNEL).log(LoggingHandler.Level.DEBUG, FUNCTION_BINDING_SELECTOR_DISCARD_FLOW)).channel(NULL_CHANNEL)).get();
    }

    @Bean(name={"functionBindingBeanPostProcessor"})
    public BeanPostProcessor functionBindingBeanPostProcessor(final FunctionAnnotationService functionAnnotationService, final IntegrationFlowContext integrationFlowContext, final Function<String, String> resolveExpression) {
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (Supplier.class.isInstance(bean) || Function.class.isInstance(bean) || Consumer.class.isInstance(bean)) {
                    Optional.ofNullable(functionAnnotationService.findAnnotationOnBean(beanName, FunctionBinding.class)).ifPresent(functionBinding -> {
                        Type functionType = FunctionBindingConfiguration.this.discoverFunctionType(bean, beanName);
                        FunctionRegistration functionRegistration = new FunctionRegistration(bean, new String[0]).type(functionType);
                        FunctionBindingConfiguration.this.registerFunctionRegistration(beanName, functionRegistration);
                        GenericSelector selector = (GenericSelector)Optional.ofNullable(functionBinding).map(FunctionBinding::condition).filter(StringUtils::hasText).map(resolveExpression).map(ExpressionEvaluatingSelector::new).orElseGet(() -> new ExpressionEvaluatingSelector("true"));
                        if (Supplier.class.isInstance(bean)) {
                            SimpleFunctionRegistry.FunctionInvocationWrapper supplier = FunctionBindingConfiguration.this.functionFromDefinition(beanName);
                            IntegrationFlowBuilder supplierFlowBuilder = (IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.fromSupplier((Supplier)supplier).filter(selector, filter -> filter.discardChannel(FunctionBindingConfiguration.FUNCTION_BINDING_SELECTOR_DISCARD_CHANNEL).throwExceptionOnRejection(false))).log(LoggingHandler.Level.DEBUG, beanName + "." + functionBinding.output())).channel(functionBinding.output());
                            integrationFlowContext.registration((IntegrationFlow)supplierFlowBuilder.get()).register();
                        } else {
                            GenericHandler handler = (message, headers) -> {
                                SimpleFunctionRegistry.FunctionInvocationWrapper function = FunctionBindingConfiguration.this.functionFromDefinition(beanName);
                                return function.apply(message);
                            };
                            IntegrationFlowBuilder functionFlowBuilder = (IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from(FunctionBindingConfiguration.this.getGatewayInterface(Function.class.isInstance(bean)), gateway -> gateway.replyTimeout(0L)).log(LoggingHandler.Level.DEBUG, beanName + "." + functionBinding.input())).filter(selector, filter -> filter.discardChannel(FunctionBindingConfiguration.FUNCTION_BINDING_SELECTOR_DISCARD_CHANNEL).throwExceptionOnRejection(false))).handle(Message.class, handler);
                            if (Function.class.isInstance(bean)) {
                                ((IntegrationFlowBuilder)((IntegrationFlowBuilder)functionFlowBuilder.bridge()).log(LoggingHandler.Level.DEBUG, beanName + "." + functionBinding.output())).channel(functionBinding.output());
                            }
                            StandardIntegrationFlow inputChannelFlow = ((IntegrationFlowBuilder)IntegrationFlow.from((String)functionBinding.input()).gateway((IntegrationFlow)functionFlowBuilder.get(), spec -> spec.replyTimeout(Long.valueOf(0L)))).get();
                            integrationFlowContext.registration((IntegrationFlow)inputChannelFlow).register();
                        }
                    });
                }
                return bean;
            }
        };
    }

    @Bean
    @ConditionalOnClass(value={JacksonMapper.class})
    @Primary
    public JacksonMapper jacksonMapper(@Autowired(required=false) ObjectMapper objectMapper) {
        ObjectMapper copiedMapper;
        if (objectMapper == null) {
            copiedMapper = new ObjectMapper();
            copiedMapper.registerModule((Module)new JavaTimeModule());
            copiedMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            copiedMapper.configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, true);
            copiedMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        } else {
            try {
                copiedMapper = objectMapper.copy();
            }
            catch (Exception e) {
                copiedMapper = new ObjectMapper();
            }
        }
        copiedMapper.configOverride(BigDecimal.class).setFormat(JsonFormat.Value.forShape((JsonFormat.Shape)JsonFormat.Shape.STRING));
        return new JacksonMapper(copiedMapper);
    }

    public static interface BindingResolver
    extends Function<String, String> {
    }
}

