/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.messaging.config;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.activiti.cloud.common.messaging.ActivitiCloudMessagingProperties;
import org.activiti.cloud.common.messaging.config.ActivitiMessagingDestinationTransformer;
import org.activiti.cloud.common.messaging.config.FunctionBindingPropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.function.StreamFunctionConfigurationProperties;
import org.springframework.core.Ordered;

public class ActivitiMessagingDestinationsBeanPostProcessor
implements BeanPostProcessor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(ActivitiMessagingDestinationsBeanPostProcessor.class);
    private final ActivitiMessagingDestinationTransformer destinationTransformer;
    private final ActivitiCloudMessagingProperties messagingProperties;
    private final FunctionBindingPropertySource functionBindingPropertySource;
    private final StreamFunctionConfigurationProperties streamFunctionProperties;

    public ActivitiMessagingDestinationsBeanPostProcessor(ActivitiMessagingDestinationTransformer destinationTransformer, ActivitiCloudMessagingProperties messagingProperties, FunctionBindingPropertySource functionBindingPropertySource, StreamFunctionConfigurationProperties streamFunctionProperties) {
        this.destinationTransformer = destinationTransformer;
        this.messagingProperties = messagingProperties;
        this.functionBindingPropertySource = functionBindingPropertySource;
        this.streamFunctionProperties = streamFunctionProperties;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof BindingServiceProperties) {
            BindingServiceProperties bindingServiceProperties = (BindingServiceProperties)bean;
            log.info("Post-processing messaging destinations for bean {} with name {}", bean, (Object)beanName);
            ActivitiCloudMessagingProperties.FunctionRouterProperties functionRouter = this.messagingProperties.getFunctionRouter();
            bindingServiceProperties.getBindings().forEach((bindingName, bindingProperties) -> {
                String source = Optional.ofNullable(bindingProperties.getDestination()).orElse((String)bindingName);
                String destination = this.destinationTransformer.apply(source);
                bindingProperties.setDestination(destination);
                log.warn("Configured destination '{}' for binding '{}'", (Object)destination, bindingName);
            });
            if (functionRouter.isEnabled()) {
                BindingProperties functionRouterInput = new BindingProperties();
                functionRouter.getFunctionRoutes().stream().filter(bindingServiceProperties.getBindings()::containsKey).forEach(bindingName -> {
                    BindingProperties value = (BindingProperties)bindingServiceProperties.getBindings().remove(bindingName);
                    functionRouter.destinations().put((String)bindingName, value.getDestination());
                    log.warn("Configured function route '{}' for destination '{}'", bindingName, (Object)value.getDestination());
                    if (value.getGroup() != null && functionRouter.isExcludeRequiredProducerGroup((String)bindingName)) {
                        bindingServiceProperties.getBindings().entrySet().stream().filter(entry -> ((BindingProperties)entry.getValue()).getProducer() != null).filter(entry -> Objects.equals(((BindingProperties)entry.getValue()).getDestination(), value.getDestination())).forEach(entry -> {
                            ProducerProperties producer = ((BindingProperties)entry.getValue()).getProducer();
                            String excludedGroups = value.getGroup();
                            String[] producerGroups = producer.getRequiredGroups();
                            List<String> requiredGroups = Stream.of(producerGroups).filter(Predicate.not(excludedGroups::equals)).toList();
                            producer.setRequiredGroups(requiredGroups.toArray(new String[0]));
                            log.warn("Excluded producer required groups '{}' for binding '{}'", (Object)excludedGroups, entry.getKey());
                        });
                    }
                });
                functionRouter.getRoutes().keySet().stream().filter(Predicate.not(functionRouter::isFunctionRoute)).filter(functionRouter::isOverrideRequiredProducerGroup).forEach(bindingName -> Optional.ofNullable((BindingProperties)bindingServiceProperties.getBindings().get(bindingName)).map(BindingProperties::getProducer).ifPresent(producer -> {
                    List<String> overrideGroups = functionRouter.getRoutes().get(bindingName).getOverrideRequiredProducerGroups();
                    producer.setRequiredGroups(overrideGroups.toArray(new String[0]));
                    log.warn("Override producer required groups '{}' for binding '{}'", overrideGroups, bindingName);
                }));
                functionRouterInput.setDestination(functionRouter.destinations().values().stream().distinct().collect(Collectors.joining(",")));
                functionRouterInput.setGroup(functionRouter.getGroup());
                functionRouterInput.setConsumer(functionRouter.getConsumer());
                if (!functionRouter.destinations().isEmpty()) {
                    bindingServiceProperties.getBindings().put("functionRouterInput", functionRouterInput);
                    log.warn("Configured function router binding '{}'", (Object)functionRouterInput);
                } else {
                    log.warn("Skipping function router configuration with empty destinations");
                }
            }
        }
        return bean;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

