/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.messaging.config;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.activiti.cloud.common.messaging.ActivitiCloudMessagingProperties;
import org.activiti.cloud.common.messaging.config.AbstractFunctionalBindingConfiguration;
import org.activiti.cloud.common.messaging.config.FunctionAnnotationService;
import org.activiti.cloud.common.messaging.config.FunctionBindingConfiguration;
import org.activiti.cloud.common.messaging.functional.Connector;
import org.activiti.cloud.common.messaging.functional.ConnectorBinding;
import org.activiti.cloud.common.messaging.functional.ConsumerConnector;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.stream.config.BinderFactoryAutoConfiguration;
import org.springframework.cloud.stream.function.FunctionConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.integration.core.GenericHandler;
import org.springframework.integration.core.GenericSelector;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.StandardIntegrationFlow;
import org.springframework.integration.dsl.context.IntegrationFlowContext;
import org.springframework.integration.filter.ExpressionEvaluatingSelector;
import org.springframework.integration.handler.LoggingHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.StringUtils;

@AutoConfiguration(after={BinderFactoryAutoConfiguration.class, FunctionBindingConfiguration.class}, before={FunctionConfiguration.class})
public class ConnectorConfiguration
extends AbstractFunctionalBindingConfiguration {
    public static final String CONNECTOR_BINDING_SELECTOR_DISCARD_FLOW = "connectorBindingSelectorDiscardFlow";
    public static final String CONNECTOR_BINDING_SELECTOR_DISCARD_CHANNEL = "connectorBindingSelectorDiscardChannel";
    public static final String NULL_CHANNEL = "nullChannel";

    @Bean(name={"connectorBindingSelectorDiscardFlow"})
    IntegrationFlow functionBindingSelectorDiscardFlow() {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from((String)CONNECTOR_BINDING_SELECTOR_DISCARD_CHANNEL).log(LoggingHandler.Level.DEBUG, CONNECTOR_BINDING_SELECTOR_DISCARD_FLOW)).channel(NULL_CHANNEL)).get();
    }

    @Bean(name={"connectorBindingPostProcessor"})
    public BeanPostProcessor connectorBindingPostProcessor(final FunctionAnnotationService functionAnnotationService, final IntegrationFlowContext integrationFlowContext, final Function<String, String> resolveExpression, final ActivitiCloudMessagingProperties messagingProperties) {
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (Connector.class.isInstance(bean) || ConsumerConnector.class.isInstance(bean)) {
                    AtomicReference responseDestination = new AtomicReference();
                    Optional.ofNullable(functionAnnotationService.findAnnotationOnBean(beanName, ConnectorBinding.class)).ifPresent(connectorBinding -> {
                        Type functionType = ConnectorConfiguration.this.discoverFunctionType(bean, beanName);
                        ActivitiCloudMessagingProperties.FunctionRouterProperties functionRouter = messagingProperties.getFunctionRouter();
                        FunctionRegistration functionRegistration = new FunctionRegistration(bean, new String[0]).type(functionType);
                        String functionBeanName = ConnectorConfiguration.this.registerFunctionRegistration(beanName, functionRegistration);
                        if (functionRouter.isEnabled()) {
                            functionRouter.register(connectorBinding.input(), functionBeanName);
                        }
                        responseDestination.set(connectorBinding.outputHeader());
                        GenericHandler handler = (message, headers) -> {
                            SimpleFunctionRegistry.FunctionInvocationWrapper function = ConnectorConfiguration.this.functionFromDefinition(beanName);
                            Object result = function.apply(message);
                            Message response = null;
                            if (result != null) {
                                response = MessageBuilder.withPayload((Object)result).build();
                                String destination = (String)headers.get(responseDestination.get(), String.class);
                                if (StringUtils.hasText((String)destination)) {
                                    ConnectorConfiguration.this.getStreamBridge().send(destination, (Object)response);
                                    return null;
                                }
                            }
                            return response;
                        };
                        GenericSelector selector = (GenericSelector)Optional.ofNullable(connectorBinding).map(ConnectorBinding::condition).filter(StringUtils::hasText).map(resolveExpression).map(ExpressionEvaluatingSelector::new).orElseGet(() -> new ExpressionEvaluatingSelector("true"));
                        GenericSelector connectorType = (GenericSelector)Optional.ofNullable(connectorBinding).map(ConnectorBinding::connectorType).filter(StringUtils::hasText).map(resolveExpression).map(it -> "headers.containsKey('connectorType') && headers['connectorType']=='" + it + "'").map(ExpressionEvaluatingSelector::new).orElseGet(() -> new ExpressionEvaluatingSelector("true"));
                        StandardIntegrationFlow connectorFlow = ((IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from(ConnectorConfiguration.this.getGatewayInterface(Function.class.isInstance(bean)), gateway -> gateway.replyTimeout(0L)).log(LoggingHandler.Level.DEBUG, beanName + ".integrationRequest")).filter(selector, filter -> filter.discardChannel(ConnectorConfiguration.CONNECTOR_BINDING_SELECTOR_DISCARD_CHANNEL).throwExceptionOnRejection(false))).filter(connectorType, filter -> filter.discardChannel(ConnectorConfiguration.CONNECTOR_BINDING_SELECTOR_DISCARD_CHANNEL).throwExceptionOnRejection(false))).handle(Message.class, handler)).log(LoggingHandler.Level.DEBUG, beanName + ".integrationResult")).bridge()).get();
                        String inputChannel = connectorBinding.input();
                        StandardIntegrationFlow inputChannelFlow = ((IntegrationFlowBuilder)IntegrationFlow.from((String)inputChannel).gateway((IntegrationFlow)connectorFlow, spec -> spec.replyTimeout(Long.valueOf(0L)))).get();
                        integrationFlowContext.registration((IntegrationFlow)inputChannelFlow).register();
                    });
                }
                return bean;
            }
        };
    }
}

