/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.security.feign;

import java.util.Optional;
import org.activiti.cloud.security.feign.AuthTokenRequestInterceptor;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2AccessToken;

public class ClientCredentialsAuthRequestInterceptor
implements AuthTokenRequestInterceptor {
    private final OAuth2AuthorizedClientManager authorizedClientManager;
    private final ClientRegistration clientRegistration;

    public ClientCredentialsAuthRequestInterceptor(OAuth2AuthorizedClientManager authorizedClientManager, ClientRegistration clientRegistration) {
        this.authorizedClientManager = authorizedClientManager;
        this.clientRegistration = clientRegistration;
    }

    @Override
    public Optional<String> getToken() {
        OAuth2AuthorizeRequest oAuth2AuthorizeRequest = OAuth2AuthorizeRequest.withClientRegistrationId((String)this.clientRegistration.getRegistrationId()).principal("activiti").build();
        OAuth2AuthorizedClient client = this.authorizedClientManager.authorize(oAuth2AuthorizeRequest);
        OAuth2AccessToken accessToken = client.getAccessToken();
        return Optional.of(accessToken.getTokenValue());
    }
}

