/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.connectors;

import org.activiti.cloud.api.process.model.IntegrationRequest;
import org.activiti.services.connectors.message.IntegrationContextMessageBuilderFactory;
import org.springframework.cloud.stream.binding.BinderAwareChannelResolver;
import org.springframework.messaging.Message;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

public class IntegrationRequestSender {
    public static final String CONNECTOR_TYPE = "connectorType";
    private final BinderAwareChannelResolver resolver;
    private final IntegrationContextMessageBuilderFactory messageBuilderFactory;

    public IntegrationRequestSender(BinderAwareChannelResolver resolver, IntegrationContextMessageBuilderFactory messageBuilderFactory) {
        this.resolver = resolver;
        this.messageBuilderFactory = messageBuilderFactory;
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT)
    public void sendIntegrationRequest(IntegrationRequest event) {
        this.resolver.resolveDestination(event.getIntegrationContext().getConnectorType()).send(this.buildIntegrationRequestMessage(event));
    }

    private Message<IntegrationRequest> buildIntegrationRequestMessage(IntegrationRequest event) {
        return this.messageBuilderFactory.create(event.getIntegrationContext()).withPayload((Object)event).build();
    }
}

