/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.connectors.behavior;

import java.util.Date;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.impl.CloudRuntimeEntityImpl;
import org.activiti.cloud.api.process.model.impl.IntegrationRequestImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudIntegrationRequestedEventImpl;
import org.activiti.cloud.services.events.configuration.RuntimeBundleProperties;
import org.activiti.cloud.services.events.converter.RuntimeBundleInfoAppender;
import org.activiti.cloud.services.events.listeners.ProcessEngineEventsAggregator;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.delegate.TriggerableActivityBehavior;
import org.activiti.engine.impl.persistence.entity.Entity;
import org.activiti.engine.impl.persistence.entity.integration.IntegrationContextEntity;
import org.activiti.engine.impl.persistence.entity.integration.IntegrationContextManager;
import org.activiti.runtime.api.connector.DefaultServiceTaskBehavior;
import org.activiti.runtime.api.connector.IntegrationContextBuilder;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.context.ApplicationEventPublisher;

public class MQServiceTaskBehavior
extends AbstractBpmnActivityBehavior
implements TriggerableActivityBehavior {
    private final IntegrationContextManager integrationContextManager;
    private final ApplicationEventPublisher eventPublisher;
    private final IntegrationContextBuilder integrationContextBuilder;
    private final RuntimeBundleInfoAppender runtimeBundleInfoAppender;
    private final DefaultServiceTaskBehavior defaultServiceTaskBehavior;
    private final ProcessEngineEventsAggregator processEngineEventsAggregator;
    private final RuntimeBundleProperties runtimeBundleProperties;
    private final BindingServiceProperties bindingServiceProperties;

    public MQServiceTaskBehavior(IntegrationContextManager integrationContextManager, ApplicationEventPublisher eventPublisher, IntegrationContextBuilder integrationContextBuilder, RuntimeBundleInfoAppender runtimeBundleInfoAppender, DefaultServiceTaskBehavior defaultServiceTaskBehavior, ProcessEngineEventsAggregator processEngineEventsAggregator, RuntimeBundleProperties runtimeBundleProperties, BindingServiceProperties bindingServiceProperties) {
        this.integrationContextManager = integrationContextManager;
        this.eventPublisher = eventPublisher;
        this.integrationContextBuilder = integrationContextBuilder;
        this.runtimeBundleInfoAppender = runtimeBundleInfoAppender;
        this.defaultServiceTaskBehavior = defaultServiceTaskBehavior;
        this.processEngineEventsAggregator = processEngineEventsAggregator;
        this.runtimeBundleProperties = runtimeBundleProperties;
        this.bindingServiceProperties = bindingServiceProperties;
    }

    public void execute(DelegateExecution execution) {
        if (this.defaultServiceTaskBehavior.hasConnectorBean(execution)) {
            this.defaultServiceTaskBehavior.execute(execution);
        } else {
            IntegrationContextEntity integrationContextEntity = this.storeIntegrationContext(execution);
            IntegrationContext integrationContext = this.integrationContextBuilder.from(integrationContextEntity, execution);
            this.publishSpringEvent(integrationContext);
            this.aggregateCloudIntegrationRequestedEvent(integrationContext);
        }
    }

    private void aggregateCloudIntegrationRequestedEvent(IntegrationContext integrationContext) {
        if (this.runtimeBundleProperties.getEventsProperties().isIntegrationAuditEventsEnabled()) {
            CloudIntegrationRequestedEventImpl cloudEvent = new CloudIntegrationRequestedEventImpl(integrationContext);
            this.processEngineEventsAggregator.add((CloudRuntimeEvent)cloudEvent);
        }
    }

    private void publishSpringEvent(IntegrationContext integrationContext) {
        IntegrationRequestImpl integrationRequest = new IntegrationRequestImpl(integrationContext);
        String resultDestination = this.bindingServiceProperties.getBindingDestination("integrationResultsConsumer");
        String errorDestination = this.bindingServiceProperties.getBindingDestination("integrationErrorsConsumer");
        integrationRequest.setErrorDestination(errorDestination);
        integrationRequest.setResultDestination(resultDestination);
        this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEntityImpl)integrationRequest);
        this.eventPublisher.publishEvent((Object)integrationRequest);
    }

    private IntegrationContextEntity storeIntegrationContext(DelegateExecution execution) {
        IntegrationContextEntity integrationContext = this.buildIntegrationContext(execution);
        this.integrationContextManager.insert((Entity)integrationContext);
        return integrationContext;
    }

    private IntegrationContextEntity buildIntegrationContext(DelegateExecution execution) {
        IntegrationContextEntity integrationContext = (IntegrationContextEntity)this.integrationContextManager.create();
        integrationContext.setExecutionId(execution.getId());
        integrationContext.setProcessInstanceId(execution.getProcessInstanceId());
        integrationContext.setProcessDefinitionId(execution.getProcessDefinitionId());
        integrationContext.setFlowNodeId(execution.getCurrentActivityId());
        integrationContext.setCreatedDate(new Date());
        return integrationContext;
    }

    public void trigger(DelegateExecution execution, String signalEvent, Object signalData) {
        this.leave(execution);
    }
}

