/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.connectors.conf;

import org.activiti.engine.RepositoryService;
import org.activiti.services.connectors.conf.ConnectorDestinationMappingStrategy;
import org.activiti.services.connectors.conf.ConnectorImplementationsProvider;
import org.activiti.services.connectors.conf.ConnectorMessagingDestinationsConfigurer;
import org.activiti.services.connectors.conf.RepositoryConnectorImplementationsProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.stream.config.BinderFactoryAutoConfiguration;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={BinderFactoryAutoConfiguration.class})
public class CloudConnectorsMessagingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ConnectorImplementationsProvider connectorDestinationsProvider(RepositoryService repositoryService) {
        return new RepositoryConnectorImplementationsProvider(repositoryService);
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectorDestinationMappingStrategy destinationMappingStrategy() {
        return new ConnectorDestinationMappingStrategy(){};
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectorMessagingDestinationsConfigurer connectorMessagingDestinationsConfigurer(BindingServiceProperties bindingServiceProperties, ConnectorImplementationsProvider destinationsProvider, ConnectorDestinationMappingStrategy destinationMappingStrategy) {
        return new ConnectorMessagingDestinationsConfigurer(destinationsProvider, destinationMappingStrategy, bindingServiceProperties);
    }
}

