/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.listeners;

import java.util.List;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.services.events.ProcessEngineChannels;
import org.activiti.cloud.services.events.converter.RuntimeBundleInfoAppender;
import org.activiti.cloud.services.events.message.MessageBuilderChainFactory;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandContextCloseListener;
import org.springframework.messaging.Message;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Transactional
public class MessageProducerCommandContextCloseListener
implements CommandContextCloseListener {
    public static final String ROOT_EXECUTION_CONTEXT = "rootExecutionContext";
    public static final String PROCESS_ENGINE_EVENTS = "processEngineEvents";
    private final ProcessEngineChannels producer;
    private final MessageBuilderChainFactory<ExecutionContext> messageBuilderChainFactory;
    private final RuntimeBundleInfoAppender runtimeBundleInfoAppender;

    public MessageProducerCommandContextCloseListener(ProcessEngineChannels producer, MessageBuilderChainFactory<ExecutionContext> messageBuilderChainFactory, RuntimeBundleInfoAppender runtimeBundleInfoAppender) {
        Assert.notNull((Object)producer, (String)"producer must not be null");
        Assert.notNull(messageBuilderChainFactory, (String)"messageBuilderChainFactory must not be null");
        Assert.notNull((Object)runtimeBundleInfoAppender, (String)"runtimeBundleInfoAppender must not be null");
        this.producer = producer;
        this.messageBuilderChainFactory = messageBuilderChainFactory;
        this.runtimeBundleInfoAppender = runtimeBundleInfoAppender;
    }

    public void closed(CommandContext commandContext) {
        List events = (List)commandContext.getGenericAttribute(PROCESS_ENGINE_EVENTS);
        if (events != null && !events.isEmpty()) {
            ExecutionContext rootExecutionContext = (ExecutionContext)commandContext.getGenericAttribute(ROOT_EXECUTION_CONTEXT);
            CloudRuntimeEvent[] payload = (CloudRuntimeEvent[])events.stream().filter(CloudRuntimeEventImpl.class::isInstance).map(CloudRuntimeEventImpl.class::cast).map(this.runtimeBundleInfoAppender::appendRuntimeBundleInfoTo).toArray(CloudRuntimeEvent[]::new);
            Message message = this.messageBuilderChainFactory.create(rootExecutionContext).withPayload(payload).build();
            this.producer.auditProducer().send(message);
        }
    }

    public void closing(CommandContext commandContext) {
    }

    public void afterSessionsFlush(CommandContext commandContext) {
    }

    public void closeFailure(CommandContext commandContext) {
    }
}

