/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.listeners;

import java.util.Optional;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.process.runtime.events.ProcessCreatedEvent;
import org.activiti.api.process.runtime.events.listener.ProcessEventListener;
import org.activiti.api.runtime.shared.security.PrincipalIdentityProvider;
import org.activiti.api.runtime.shared.security.SecurityContextPrincipalProvider;
import org.activiti.engine.RuntimeService;

public class ProcessStartedActorProviderEventListener
implements ProcessEventListener<ProcessCreatedEvent> {
    private final RuntimeService runtimeService;
    private final SecurityContextPrincipalProvider securityContextPrincipalProvider;
    private final PrincipalIdentityProvider principalIdentityProvider;

    public ProcessStartedActorProviderEventListener(RuntimeService runtimeService, SecurityContextPrincipalProvider securityContextPrincipalProvider, PrincipalIdentityProvider principalIdentityProvider) {
        this.runtimeService = runtimeService;
        this.securityContextPrincipalProvider = securityContextPrincipalProvider;
        this.principalIdentityProvider = principalIdentityProvider;
    }

    public void onEvent(ProcessCreatedEvent event) {
        this.securityContextPrincipalProvider.getCurrentPrincipal().ifPresent(principal -> Optional.ofNullable(principal.getName()).map(String::getBytes).ifPresent(details -> this.runtimeService.addUserIdentityLink(((ProcessInstance)event.getEntity()).getId(), this.principalIdentityProvider.getUserId(principal), "actor", details)));
    }
}

