/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.job.executor;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.binding.SubscribableChannelBindingTargetFactory;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.messaging.SubscribableChannel;

public class JobMessageInputChannelFactory {
    private final SubscribableChannelBindingTargetFactory bindingTargetFactory;
    private final BindingServiceProperties bindingServiceProperties;
    private final ConfigurableListableBeanFactory beanFactory;

    public JobMessageInputChannelFactory(SubscribableChannelBindingTargetFactory bindingTargetFactory, BindingServiceProperties bindingServiceProperties, ConfigurableListableBeanFactory beanFactory) {
        this.bindingTargetFactory = bindingTargetFactory;
        this.bindingServiceProperties = bindingServiceProperties;
        this.beanFactory = beanFactory;
    }

    public SubscribableChannel createInputChannel(String consumerName, BindingProperties bindingProperties) {
        this.bindingServiceProperties.getBindings().put(consumerName, bindingProperties);
        SubscribableChannel channel = this.bindingTargetFactory.createInput(consumerName);
        this.beanFactory.registerSingleton(consumerName, (Object)channel);
        channel = (SubscribableChannel)this.beanFactory.initializeBean((Object)channel, consumerName);
        return channel;
    }
}

