/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.job.executor;

import org.activiti.cloud.common.messaging.config.ActivitiMessagingDestinationsAutoConfiguration;
import org.activiti.cloud.services.events.configuration.RuntimeBundleProperties;
import org.activiti.cloud.services.job.executor.DefaultJobMessageHandlerFactory;
import org.activiti.cloud.services.job.executor.DefaultJobMessageProducer;
import org.activiti.cloud.services.job.executor.DefaultMessageBasedJobManagerFactory;
import org.activiti.cloud.services.job.executor.JobMessageBuilderFactory;
import org.activiti.cloud.services.job.executor.JobMessageHandlerFactory;
import org.activiti.cloud.services.job.executor.JobMessageInputChannelFactory;
import org.activiti.cloud.services.job.executor.JobMessageProducer;
import org.activiti.cloud.services.job.executor.MessageBasedJobManagerConfigurator;
import org.activiti.cloud.services.job.executor.MessageBasedJobManagerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.binding.SubscribableChannelBindingTargetFactory;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnProperty(name={"spring.activiti.asyncExecutorActivate"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={ActivitiMessagingDestinationsAutoConfiguration.class})
public class MessageBasedJobManagerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public JobMessageBuilderFactory jobMessageBuilderFactory(RuntimeBundleProperties properties) {
        return new JobMessageBuilderFactory(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public JobMessageInputChannelFactory jobMessageInputChannelFactory(SubscribableChannelBindingTargetFactory bindingTargetFactory, BindingServiceProperties bindingServiceProperties, ConfigurableListableBeanFactory beanFactory) {
        return new JobMessageInputChannelFactory(bindingTargetFactory, bindingServiceProperties, beanFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageBasedJobManagerFactory messageBasedJobManagerFactory(BindingServiceProperties bindingServiceProperties, JobMessageProducer jobMessageProducer) {
        return new DefaultMessageBasedJobManagerFactory(bindingServiceProperties, jobMessageProducer);
    }

    @Bean
    @ConditionalOnMissingBean
    public JobMessageProducer jobMessageProducer(StreamBridge streamBridge, ApplicationEventPublisher eventPublisher, JobMessageBuilderFactory jobMessageBuilderFactory) {
        return new DefaultJobMessageProducer(streamBridge, eventPublisher, jobMessageBuilderFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public JobMessageHandlerFactory jobMessageHandlerFactory() {
        return new DefaultJobMessageHandlerFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageBasedJobManagerConfigurator messageBasedJobManagerConfigurator(ConfigurableListableBeanFactory beanFactory, BindingService bindingService, JobMessageInputChannelFactory jobMessageInputChannelFactory, MessageBasedJobManagerFactory messageBasedJobManagerFactory, JobMessageHandlerFactory jobMessageHandlerFactory) {
        return new MessageBasedJobManagerConfigurator(beanFactory, bindingService, jobMessageInputChannelFactory, messageBasedJobManagerFactory, jobMessageHandlerFactory);
    }
}

