/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.job.executor;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.asyncexecutor.ExecuteAsyncRunnable;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

public class JobMessageHandler
implements MessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(JobMessageHandler.class);
    private final ProcessEngineConfigurationImpl processEngineConfiguration;

    public JobMessageHandler(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public void handleMessage(Message<?> message) throws MessagingException {
        logger.debug("Handling job message: {} ", message);
        try {
            String jobId = new String((byte[])message.getPayload());
            logger.info("Received job message with id: " + jobId);
            JobEntity job = this.findJobById(jobId);
            if (job != null) {
                logger.debug("Found existing job: {}", (Object)job);
                this.executeJob(job);
                logger.debug("Job executed: {}", (Object)job);
            } else {
                logger.info("Job " + jobId + " does not exist. Job message has been dropped.");
            }
        }
        catch (Exception cause) {
            logger.error("Exception '{}' when handling job message {}", (Object)cause.getMessage(), message);
            throw new ActivitiException("Exception when handling message from job queue", (Throwable)cause);
        }
    }

    public JobEntity findJobById(final String jobId) {
        return (JobEntity)this.processEngineConfiguration.getCommandExecutor().execute((Command)new Command<JobEntity>(){

            public JobEntity execute(CommandContext commandContext) {
                return (JobEntity)commandContext.getJobEntityManager().findById(jobId);
            }
        });
    }

    public void executeJob(JobEntity job) {
        ExecuteAsyncRunnable executeAsyncRunnable = new ExecuteAsyncRunnable((Job)job, this.processEngineConfiguration);
        executeAsyncRunnable.run();
    }
}

