/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.job.executor;

import java.util.function.Consumer;
import org.activiti.cloud.common.messaging.config.ActivitiMessagingDestinationsAutoConfiguration;
import org.activiti.cloud.common.messaging.config.FunctionBindingConfiguration;
import org.activiti.cloud.common.messaging.functional.FunctionBinding;
import org.activiti.cloud.services.events.configuration.RuntimeBundleProperties;
import org.activiti.cloud.services.job.executor.AsyncExecutorJobMessageChannels;
import org.activiti.cloud.services.job.executor.DefaultJobMessageHandlerFactory;
import org.activiti.cloud.services.job.executor.DefaultJobMessageProducer;
import org.activiti.cloud.services.job.executor.DefaultMessageBasedJobManagerFactory;
import org.activiti.cloud.services.job.executor.JobMessageBuilderFactory;
import org.activiti.cloud.services.job.executor.JobMessageHandlerFactory;
import org.activiti.cloud.services.job.executor.JobMessageProducer;
import org.activiti.cloud.services.job.executor.MessageBasedJobManagerConfigurator;
import org.activiti.cloud.services.job.executor.MessageBasedJobManagerFactory;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;

@AutoConfiguration
@ConditionalOnProperty(name={"spring.activiti.asyncExecutorActivate"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={ActivitiMessagingDestinationsAutoConfiguration.class})
public class MessageBasedJobManagerAutoConfiguration {
    @Bean
    @FunctionBinding(input="asyncExecutorJobsInput")
    Consumer<Message<?>> asyncExecutorJobsInputConsumer(MessageHandler jobMessageHandler) {
        return arg_0 -> ((MessageHandler)jobMessageHandler).handleMessage(arg_0);
    }

    @Bean
    MessageHandler jobMessageHandler(JobMessageHandlerFactory jobMessageHandlerFactory, ProcessEngineConfigurationImpl processEngineConfiguration) {
        return jobMessageHandlerFactory.create(processEngineConfiguration);
    }

    @Bean
    @ConditionalOnMissingBean
    public JobMessageBuilderFactory jobMessageBuilderFactory(RuntimeBundleProperties properties) {
        return new JobMessageBuilderFactory(properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageBasedJobManagerFactory messageBasedJobManagerFactory(BindingServiceProperties bindingServiceProperties, JobMessageProducer jobMessageProducer) {
        return new DefaultMessageBasedJobManagerFactory(bindingServiceProperties, jobMessageProducer);
    }

    @Bean
    @ConditionalOnMissingBean
    public JobMessageProducer jobMessageProducer(StreamBridge streamBridge, ApplicationEventPublisher eventPublisher, JobMessageBuilderFactory jobMessageBuilderFactory, FunctionBindingConfiguration.BindingResolver bindingResolver) {
        return new DefaultJobMessageProducer(streamBridge, eventPublisher, jobMessageBuilderFactory, bindingResolver);
    }

    @Bean
    @ConditionalOnMissingBean
    public JobMessageHandlerFactory jobMessageHandlerFactory() {
        return new DefaultJobMessageHandlerFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageBasedJobManagerConfigurator messageBasedJobManagerConfigurator(ConfigurableListableBeanFactory beanFactory, MessageBasedJobManagerFactory messageBasedJobManagerFactory) {
        return new MessageBasedJobManagerConfigurator(beanFactory, messageBasedJobManagerFactory);
    }

    @Configuration
    static class AsyncExecutorJobMessageChannelsConfiguration
    implements AsyncExecutorJobMessageChannels {
        AsyncExecutorJobMessageChannelsConfiguration() {
        }
    }
}

