/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.job.executor;

import org.activiti.cloud.services.job.executor.JobMessageHandlerFactory;
import org.activiti.cloud.services.job.executor.JobMessageInputChannelFactory;
import org.activiti.cloud.services.job.executor.MessageBasedJobManager;
import org.activiti.cloud.services.job.executor.MessageBasedJobManagerFactory;
import org.activiti.engine.cfg.ProcessEngineConfigurator;
import org.activiti.engine.impl.asyncexecutor.JobManager;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.binding.BindingService;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.context.SmartLifecycle;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;

public class MessageBasedJobManagerConfigurator
implements ProcessEngineConfigurator,
SmartLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(MessageBasedJobManagerConfigurator.class);
    private static final String MESSAGE_BASED_JOB_MANAGER = "messageBasedJobManager";
    public static final String JOB_MESSAGE_HANDLER = "jobMessageHandler";
    private final BindingService bindingService;
    private final JobMessageInputChannelFactory inputChannelFactory;
    private final MessageBasedJobManagerFactory messageBasedJobManagerFactory;
    private final JobMessageHandlerFactory jobMessageHandlerFactory;
    private final ConfigurableListableBeanFactory beanFactory;
    private MessageBasedJobManager messageBasedJobManager;
    private MessageHandler jobMessageHandler;
    private SubscribableChannel inputChannel;
    private ProcessEngineConfigurationImpl configuration;
    private boolean running = false;

    public MessageBasedJobManagerConfigurator(ConfigurableListableBeanFactory beanFactory, BindingService bindingService, JobMessageInputChannelFactory inputChannelFactory, MessageBasedJobManagerFactory messageBasedJobManagerFactory, JobMessageHandlerFactory jobMessageHandlerFactory) {
        this.bindingService = bindingService;
        this.inputChannelFactory = inputChannelFactory;
        this.messageBasedJobManagerFactory = messageBasedJobManagerFactory;
        this.jobMessageHandlerFactory = jobMessageHandlerFactory;
        this.beanFactory = beanFactory;
    }

    protected MessageHandler createJobMessageHandler(ProcessEngineConfigurationImpl configuration) {
        MessageHandler messageHandler = this.jobMessageHandlerFactory.create(configuration);
        return this.registerBean(JOB_MESSAGE_HANDLER, messageHandler);
    }

    protected MessageBasedJobManager createMessageBasedJobManager(ProcessEngineConfigurationImpl configuration) {
        MessageBasedJobManager instance = this.messageBasedJobManagerFactory.create(configuration);
        return this.registerBean(MESSAGE_BASED_JOB_MANAGER, instance);
    }

    public void beforeInit(ProcessEngineConfigurationImpl configuration) {
        this.messageBasedJobManager = this.createMessageBasedJobManager(configuration);
        configuration.setAsyncExecutorActivate(false);
        configuration.setAsyncExecutorMessageQueueMode(true);
        configuration.setJobManager((JobManager)this.messageBasedJobManager);
        logger.info("Configured message based job manager class: {}", ((Object)((Object)this.messageBasedJobManager)).getClass());
    }

    public void configure(ProcessEngineConfigurationImpl configuration) {
        this.configuration = configuration;
        String channelName = this.messageBasedJobManager.getInputChannelName();
        BindingProperties bindingProperties = this.messageBasedJobManager.getBindingProperties();
        this.inputChannel = this.inputChannelFactory.createInputChannel(channelName, bindingProperties);
        logger.info("Configured message job input channel '{}' with bindings: {}", (Object)channelName, (Object)bindingProperties);
    }

    public int getPriority() {
        return 0;
    }

    public void start() {
        logger.info("Subscribing job message handler to input channel {}", (Object)this.messageBasedJobManager.getInputChannelName());
        this.jobMessageHandler = this.createJobMessageHandler(this.configuration);
        this.inputChannel.subscribe(this.jobMessageHandler);
        this.bindingService.bindConsumer((Object)this.inputChannel, this.messageBasedJobManager.getInputChannelName());
        if (!this.configuration.getAsyncExecutor().isActive()) {
            this.configuration.getAsyncExecutor().start();
        }
        this.running = true;
    }

    public void stop() {
        logger.info("Unsubscribing job message handler to input channel {}", (Object)this.messageBasedJobManager.getInputChannelName());
        try {
            this.bindingService.unbindConsumers(this.messageBasedJobManager.getInputChannelName());
            this.inputChannel.unsubscribe(this.jobMessageHandler);
            if (this.configuration.getAsyncExecutor().isActive()) {
                this.configuration.getAsyncExecutor().shutdown();
            }
        }
        finally {
            this.running = false;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    protected <T> T registerBean(String name, T bean) {
        this.beanFactory.registerSingleton(name, bean);
        return (T)this.beanFactory.initializeBean(bean, name);
    }
}

