/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.graphiql;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnWebApplication
@ConditionalOnProperty(value={"activiti.cloud.services.oauth2.iam-name"}, havingValue="keycloak", matchIfMissing=true)
public class KeycloakJsonController {
    @Value(value="${keycloak.auth-server-url}")
    private String authServerUrl;
    @Value(value="${keycloak.realm}")
    private String realm;
    @Value(value="${keycloak.resource}")
    private String resource;
    @Value(value="${keycloak.public-client}")
    private Boolean publicClient;
    @Value(value="${keycloak.confidential-port:0}")
    private Integer confidentialPort;
    @Value(value="${keycloak.ssl-required:none}")
    private String sslRequired;

    @GetMapping(value={"graphiql/keycloak.json"}, produces={"application/json"})
    public ResponseEntity<Map<String, Object>> get() {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        values.put("auth-server-url", this.authServerUrl);
        values.put("realm", this.realm);
        values.put("ssl-required", this.sslRequired);
        values.put("resource", this.resource);
        values.put("public-client", this.publicClient);
        values.put("confidential-port", this.confidentialPort);
        return ResponseEntity.ok(values);
    }
}

