/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.jpa.query;

import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLSchemaConfigurer;
import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLShemaRegistration;
import com.introproventures.graphql.jpa.query.schema.JavaScalars;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaSchemaBuilder;
import graphql.GraphQL;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import javax.persistence.EntityManager;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.VariableValue;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={GraphQL.class, ProcessInstanceEntity.class})
@ConditionalOnProperty(name={"spring.activiti.cloud.services.notifications.graphql.jpa-query.enabled"}, matchIfMissing=true)
public class ActivitiGraphQLSchemaAutoConfiguration {

    @Configuration
    @EntityScan(basePackageClasses={ProcessInstanceEntity.class})
    public static class ActivitiGraphQLSchemaConfigurer
    implements GraphQLSchemaConfigurer {
        private final EntityManager entityManager;

        public ActivitiGraphQLSchemaConfigurer(EntityManager entityManager) {
            this.entityManager = entityManager;
            JavaScalars.register(VariableValue.class, (GraphQLScalarType)new GraphQLScalarType("VariableValue", "VariableValue type", (Coercing)new JavaScalars.GraphQLObjectCoercing()));
        }

        public void configure(GraphQLShemaRegistration registry) {
            GraphQLSchema graphQLSchema = new GraphQLJpaSchemaBuilder(this.entityManager).name("Query").entityPath(ProcessInstanceEntity.class.getPackage().getName()).description("Activiti Cloud Query Schema").build();
            registry.register(graphQLSchema);
        }
    }
}

