/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.jpa.query;

import com.introproventures.graphql.jpa.query.autoconfigure.EnableGraphQLJpaQuerySchema;
import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLJPASchemaBuilderCustomizer;
import com.introproventures.graphql.jpa.query.schema.JavaScalars;
import graphql.GraphQL;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import java.util.Optional;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.VariableValue;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={GraphQL.class, ProcessInstanceEntity.class})
@ConditionalOnProperty(name={"spring.activiti.cloud.services.notifications.graphql.jpa-query.enabled"}, matchIfMissing=true)
@EnableGraphQLJpaQuerySchema(basePackageClasses={ProcessInstanceEntity.class})
public class ActivitiGraphQLSchemaAutoConfiguration {
    @Value(value="${spring.activiti.cloud.services.notifications.graphql.jpa-query.aggregate.enabled:true}")
    private boolean isAggregateEnabled;

    @Bean
    GraphQLJPASchemaBuilderCustomizer graphQLJPASchemaBuilderCustomizer() {
        return builder -> builder.name("Query").description("Activiti Cloud Query Schema").enableAggregate(this.isAggregateEnabled).scalar(VariableValue.class, GraphQLScalarType.newScalar().name("VariableValue").coercing((Coercing)new JavaScalars.GraphQLObjectCoercing(this){

            public Object serialize(Object input) {
                return Optional.ofNullable(input).filter(VariableValue.class::isInstance).map(VariableValue.class::cast).map(it -> Optional.ofNullable(it.getValue()).orElse(Optional.empty())).orElseGet(() -> super.serialize(input));
            }
        }).build());
    }
}

