/*
 * Copyright 2017-2020 Alfresco Software, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.cloud.services.notifications.qraphql.ws.security;

import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthenticationToken;

public class JWSAuthentication extends AbstractAuthenticationToken implements Authentication {

    private static final long serialVersionUID = 1L;

    private String token;
    private User principal;

    public JWSAuthentication(String token) {
        this(token, null, null);
        setAuthenticated(false);
    }

    public JWSAuthentication(BearerTokenAuthenticationToken bearerTokenAuthenticationToken) {
        this(
            bearerTokenAuthenticationToken.getToken(),
            bearerTokenAuthenticationToken.getPrincipal() instanceof User
                ? (User) bearerTokenAuthenticationToken.getPrincipal()
                : null,
            bearerTokenAuthenticationToken.getAuthorities()
        );
        setAuthenticated(bearerTokenAuthenticationToken.isAuthenticated());
    }

    public JWSAuthentication(String token, User principal, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.token = token;
        this.principal = principal;

        setAuthenticated(true);
    }

    @Override
    public Object getCredentials() {
        return token;
    }

    @Override
    public Object getPrincipal() {
        return principal;
    }
}
