/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.qraphql.ws.security;

import java.util.function.Function;
import org.activiti.cloud.security.authorization.CustomAuthorizationManager;
import org.activiti.cloud.services.common.security.jwt.JwtAccessTokenValidator;
import org.activiti.cloud.services.common.security.jwt.JwtAdapter;
import org.activiti.cloud.services.common.security.jwt.JwtUserInfoUriAuthenticationConverter;
import org.activiti.cloud.services.notifications.qraphql.ws.security.JWSAuthenticationInterceptorConfigurer;
import org.activiti.cloud.services.notifications.qraphql.ws.security.JWSAuthenticationManager;
import org.activiti.cloud.services.notifications.qraphql.ws.security.JWSBearerTokenAuthenticationExtractor;
import org.activiti.cloud.services.notifications.qraphql.ws.security.JwtInterceptorConfigurer;
import org.activiti.cloud.services.notifications.qraphql.ws.security.SecurityWebSocketInterceptor;
import org.activiti.cloud.services.notifications.qraphql.ws.security.WebSocketMessageBrokerSecurityConfigurer;
import org.activiti.cloud.services.notifications.qraphql.ws.security.tokenverifier.GraphQLAccessTokenVerifier;
import org.activiti.cloud.services.notifications.qraphql.ws.security.tokenverifier.jwt.JwtAccessTokenVerifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.graphql.server.WebSocketGraphQlInterceptor;
import org.springframework.graphql.server.support.BearerTokenAuthenticationExtractor;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;

@AutoConfiguration
@ConditionalOnProperty(name={"spring.activiti.cloud.services.notification.graphql.ws.security.enabled"}, matchIfMissing=true)
@Import(value={WebSocketMessageBrokerSecurityConfigurer.class})
public class WebSocketMessageBrokerSecurityAutoConfiguration {

    @Configuration
    @PropertySources(value={@PropertySource(value={"classpath:META-INF/graphql-security.properties"}), @PropertySource(value={"classpath:graphql-security.properties"}, ignoreResourceNotFound=true)})
    public static class SpringNativeWebSocketMessageBrokerSecurityConfiguration {
        @Value(value="${spring.activiti.cloud.services.notifications.graphql.ws.security.authorities:}")
        private String[] authorities;
        @Value(value="${spring.activiti.cloud.services.notifications.graphql.ws.security.permissions:}")
        private String[] permissions;

        @Bean
        JWSBearerTokenAuthenticationExtractor jwsBearerTokenAuthenticationExtractor() {
            return new JWSBearerTokenAuthenticationExtractor(new BearerTokenAuthenticationExtractor());
        }

        @Bean
        public WebSocketGraphQlInterceptor authenticationInterceptor(JWSAuthenticationManager jwsAuthenticationManager, JWSBearerTokenAuthenticationExtractor jwsBearerTokenAuthenticationExtractor) {
            return new SecurityWebSocketInterceptor(jwsBearerTokenAuthenticationExtractor, jwsAuthenticationManager, (AuthorizationManager<?>)new CustomAuthorizationManager(this.authorities, this.permissions));
        }
    }

    @Configuration
    @PropertySources(value={@PropertySource(value={"classpath:META-INF/graphql-security.properties"}), @PropertySource(value={"classpath:graphql-security.properties"}, ignoreResourceNotFound=true)})
    public static class DefaultWebSocketMessageBrokerSecurityConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public JWSAuthenticationInterceptorConfigurer jwsTokenChannelSecurityContextConfigurer(JWSAuthenticationManager keycloakWebSocketAuthManager) {
            return new JWSAuthenticationInterceptorConfigurer(keycloakWebSocketAuthManager);
        }

        @Bean
        @ConditionalOnMissingBean
        public JwtInterceptorConfigurer jwsTokenChannelAuthenticationConfigurer(GraphQLAccessTokenVerifier keycloakTokenVerifier) {
            return new JwtInterceptorConfigurer(keycloakTokenVerifier);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnExpression(value="'${activiti.cloud.services.oauth2.iam-name}'!='keycloak'")
        public GraphQLAccessTokenVerifier jwtTokenVerifier(JwtAccessTokenValidator jwtAccessTokenValidator, JwtUserInfoUriAuthenticationConverter jwtUserInfoUriAuthenticationConverter, JwtDecoder jwtDecoder) {
            return new JwtAccessTokenVerifier(jwtAccessTokenValidator, jwtUserInfoUriAuthenticationConverter, jwtDecoder, jwt -> jwt.getClaimAsStringList("role"));
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(value={"activiti.cloud.services.oauth2.iam-name"}, havingValue="keycloak")
        public GraphQLAccessTokenVerifier keycloakTokenVerifier(JwtAccessTokenValidator jwtAccessTokenValidator, JwtUserInfoUriAuthenticationConverter jwtUserInfoUriAuthenticationConverter, JwtDecoder jwtDecoder, Function<Jwt, JwtAdapter> jwtAdapterSupplier) {
            return new JwtAccessTokenVerifier(jwtAccessTokenValidator, jwtUserInfoUriAuthenticationConverter, jwtDecoder, jwt -> ((JwtAdapter)jwtAdapterSupplier.apply((Jwt)jwt)).getRoles());
        }

        @Bean
        @ConditionalOnMissingBean
        public JWSAuthenticationManager keycloakWebSocketAuthManager(GraphQLAccessTokenVerifier keycloakTokenVerifier) {
            return new JWSAuthenticationManager(keycloakTokenVerifier);
        }
    }
}

