/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.ws.config;

import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import org.activiti.cloud.services.notifications.graphql.ws.config.GraphQLWebSocketMessageBrokerConfigurationProperties;
import org.activiti.cloud.services.notifications.graphql.ws.transport.GraphQLBrokerMessageHandler;
import org.activiti.cloud.services.notifications.graphql.ws.transport.GraphQLBrokerSubProtocolHandler;
import org.activiti.cloud.services.notifications.graphql.ws.transport.GraphQLSubscriptionExecutor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.AbstractSubscribableChannel;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.DelegatingWebSocketMessageBrokerConfiguration;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.messaging.SubProtocolHandler;
import org.springframework.web.socket.messaging.SubProtocolWebSocketHandler;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.standard.ServletServerContainerFactoryBean;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;
import org.springframework.web.socket.server.support.HttpSessionHandshakeInterceptor;

@AutoConfiguration
@ConditionalOnWebApplication
@ConditionalOnClass(value={GraphQL.class, EnableWebSocketMessageBroker.class})
@ConditionalOnProperty(name={"spring.activiti.cloud.services.query.graphql.ws.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={GraphQLWebSocketMessageBrokerConfigurationProperties.class})
@PropertySources(value={@PropertySource(value={"classpath:META-INF/graphql-ws.properties"}), @PropertySource(value={"classpath:graphql-ws.properties"}, ignoreResourceNotFound=true)})
public class GraphQLWebSocketMessageBrokerAutoConfiguration {

    @EnableWebSocket
    @Configuration
    public static class DefaultGraphQLWebSocketMessageBrokerConfiguration
    extends DelegatingWebSocketMessageBrokerConfiguration {
        private final GraphQLWebSocketMessageBrokerConfigurationProperties configurationProperties;

        public DefaultGraphQLWebSocketMessageBrokerConfiguration(GraphQLWebSocketMessageBrokerConfigurationProperties configurationProperties) {
            this.configurationProperties = configurationProperties;
        }

        public void configureMessageBroker(MessageBrokerRegistry registry) {
            registry.enableSimpleBroker(new String[0]);
        }

        public void registerStompEndpoints(StompEndpointRegistry registry) {
            registry.addEndpoint(new String[]{this.configurationProperties.getEndpoint()}).setHandshakeHandler((HandshakeHandler)new DefaultHandshakeHandler()).setAllowedOrigins(new String[]{this.configurationProperties.getAllowedOrigins()}).addInterceptors(new HandshakeInterceptor[]{new HttpSessionHandshakeInterceptor()});
        }

        @Bean
        @ConditionalOnMissingBean(value={GraphQLBrokerMessageHandler.class})
        public MessageHandler graphQLBrokerMessageHandler(SubscribableChannel clientInboundChannel, MessageChannel clientOutboundChannel, SubscribableChannel brokerChannel, TaskScheduler messageBrokerTaskScheduler, GraphQLSubscriptionExecutor graphQLSubscriptionExecutor) {
            GraphQLBrokerMessageHandler messageHandler = new GraphQLBrokerMessageHandler(clientInboundChannel, clientOutboundChannel, brokerChannel, graphQLSubscriptionExecutor);
            messageHandler.setTaskScheduler(messageBrokerTaskScheduler).setBufferCount(this.configurationProperties.getBufferCount()).setBufferTimeSpanMs(this.configurationProperties.getBufferTimeSpanMs().intValue());
            return messageHandler;
        }

        @Bean
        @ConditionalOnMissingBean(value={SubProtocolWebSocketHandler.class})
        public WebSocketHandler subProtocolWebSocketHandler(AbstractSubscribableChannel clientInboundChannel, AbstractSubscribableChannel clientOutboundChannel) {
            SubProtocolWebSocketHandler handler = new SubProtocolWebSocketHandler((MessageChannel)clientInboundChannel, (SubscribableChannel)clientOutboundChannel);
            handler.addProtocolHandler((SubProtocolHandler)this.graphQLBrokerSubProtocolHandler());
            handler.setDefaultProtocolHandler((SubProtocolHandler)this.graphQLBrokerSubProtocolHandler());
            return handler;
        }

        @Bean
        @ConditionalOnMissingBean
        public GraphQLBrokerSubProtocolHandler graphQLBrokerSubProtocolHandler() {
            return new GraphQLBrokerSubProtocolHandler(this.configurationProperties.getEndpoint());
        }

        @Bean
        @ConditionalOnMissingBean
        public GraphQLSubscriptionExecutor graphQLSubscriptionExecutor(GraphQLSchema graphQLSchema) {
            return new GraphQLSubscriptionExecutor(graphQLSchema);
        }

        @Bean
        public ServletServerContainerFactoryBean createWebSocketContainer() {
            ServletServerContainerFactoryBean container = new ServletServerContainerFactoryBean();
            container.setMaxTextMessageBufferSize(Integer.valueOf(65536));
            container.setMaxBinaryMessageBufferSize(Integer.valueOf(10240));
            container.setMaxSessionIdleTimeout(Long.valueOf(30000L));
            return container;
        }
    }
}

