/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.ws.transport;

import graphql.ExecutionResult;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.activiti.cloud.services.notifications.graphql.ws.api.GraphQLMessage;
import org.activiti.cloud.services.notifications.graphql.ws.api.GraphQLMessageType;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.messaging.support.MessageHeaderAccessor;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.UnicastProcessor;

public class GraphQLBrokerChannelSubscriber
implements Subscriber<ExecutionResult> {
    private static Logger log = LoggerFactory.getLogger(GraphQLBrokerChannelSubscriber.class);
    private final MessageChannel outboundChannel;
    private final Message<?> message;
    private final String operationMessageId;
    private final UnicastProcessor<ExecutionResult> processor = UnicastProcessor.create();
    private final AtomicReference<Subscription> subscriptionRef = new AtomicReference();
    private final Disposable control;

    public GraphQLBrokerChannelSubscriber(Message<?> message, String operationMessageId, MessageChannel outboundChannel, long bufferTimeSpanMs, int bufferCount) {
        this.outboundChannel = outboundChannel;
        this.operationMessageId = operationMessageId;
        this.message = message;
        this.control = Flux.from(this.processor).map(ExecutionResult::getData).subscribe(this::sendDataToClient);
    }

    public void cancel() {
        this.control.dispose();
        Subscription subscription = this.subscriptionRef.get();
        log.info("Cancel subscription {}", (Object)subscription);
        if (subscription != null) {
            try {
                subscription.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onSubscribe(Subscription s) {
        log.info("New subscription: {}", (Object)s);
        this.subscriptionRef.set(s);
        this.requestNext(1);
    }

    public void onNext(ExecutionResult executionResult) {
        log.debug("Process {} executionResult {} ", (Object)this.subscriptionRef.get(), (Object)executionResult);
        this.processor.onNext((Object)executionResult);
        this.requestNext(1);
    }

    public void onError(Throwable t) {
        log.error("Subscription {} threw an exception {}", (Object)this.subscriptionRef.get(), (Object)t);
        Map<String, List<String>> payload = Collections.singletonMap("errors", Collections.singletonList(t.getMessage()));
        GraphQLMessage operationMessage = new GraphQLMessage(this.operationMessageId, GraphQLMessageType.ERROR, payload);
        Message responseMessage = MessageBuilder.createMessage((Object)operationMessage, (MessageHeaders)this.getMessageHeaders());
        this.outboundChannel.send(responseMessage);
    }

    public void onComplete() {
        log.info("Subscription complete: {}", (Object)this.subscriptionRef.get());
        this.cancel();
        GraphQLMessage operationMessage = new GraphQLMessage(this.operationMessageId, GraphQLMessageType.COMPLETE);
        Message responseMessage = MessageBuilder.createMessage((Object)operationMessage, (MessageHeaders)this.getMessageHeaders());
        this.outboundChannel.send(responseMessage);
    }

    private void requestNext(int n) {
        Subscription subscription = this.subscriptionRef.get();
        if (subscription != null) {
            subscription.request((long)n);
        }
    }

    protected void sendDataToClient(Object data) {
        Map<String, Object> payload = Collections.singletonMap("data", data);
        GraphQLMessage operationData = new GraphQLMessage(this.operationMessageId, GraphQLMessageType.DATA, payload);
        Message responseMessage = MessageBuilder.createMessage((Object)operationData, (MessageHeaders)this.getMessageHeaders());
        this.outboundChannel.send(responseMessage);
    }

    private MessageHeaders getMessageHeaders() {
        MessageHeaderAccessor headerAccessor = SimpMessageHeaderAccessor.getMutableAccessor(this.message);
        headerAccessor.setLeaveMutable(true);
        return headerAccessor.getMessageHeaders();
    }
}

