/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.ws.transport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.activiti.cloud.services.notifications.graphql.ws.transport.GraphQLBrokerChannelSubscriber;
import org.springframework.util.Assert;

public class GraphQLBrokerSubscriptionRegistry {
    private final ConcurrentHashMap<String, SessionSubscriptionInfo> subscriptionRegistry = new ConcurrentHashMap();

    public void subscribe(String sessionId, String subscriptionId, GraphQLBrokerChannelSubscriber subscriber) {
        this.subscribe(sessionId, subscriptionId, subscriber, null);
    }

    public void subscribe(String sessionId, String subscriptionId, GraphQLBrokerChannelSubscriber subscriber, Runnable callback) {
        SessionSubscriptionInfo sessionSubscription = Optional.ofNullable(this.subscriptionRegistry.get(sessionId)).orElseGet(() -> {
            SessionSubscriptionInfo subscriptionInfo = new SessionSubscriptionInfo(sessionId);
            this.subscriptionRegistry.put(sessionId, subscriptionInfo);
            return subscriptionInfo;
        });
        sessionSubscription.addSubscription(subscriptionId, subscriber);
        if (callback != null) {
            callback.run();
        }
    }

    public void unsubscribe(String sessionId, String subscriptionId) {
        this.unsubscribe(sessionId, subscriptionId, null);
    }

    public void unsubscribe(String sessionId, String subscriptionId, Consumer<GraphQLBrokerChannelSubscriber> callback) {
        SessionSubscriptionInfo subscriptionInfo = this.subscriptionRegistry.get(sessionId);
        if (subscriptionInfo != null) {
            GraphQLBrokerChannelSubscriber subscriber = subscriptionInfo.removeSubscription(subscriptionId);
            if (callback != null && subscriber != null) {
                callback.accept(subscriber);
            }
        }
    }

    public void unsubscribe(String sessionId, Consumer<GraphQLBrokerChannelSubscriber> callback) {
        SessionSubscriptionInfo subscriptionInfo = this.subscriptionRegistry.remove(sessionId);
        if (subscriptionInfo != null) {
            subscriptionInfo.removeAll().forEach(subscriber -> {
                if (callback != null && subscriber != null) {
                    callback.accept((GraphQLBrokerChannelSubscriber)subscriber);
                }
            });
        }
    }

    public SessionSubscriptionInfo get(String sessionId) {
        return this.subscriptionRegistry.getOrDefault(sessionId, new SessionSubscriptionInfo(sessionId));
    }

    public static class SessionSubscriptionInfo {
        private final String sessionId;
        private final Map<String, GraphQLBrokerChannelSubscriber> subscriberLookup = new ConcurrentHashMap<String, GraphQLBrokerChannelSubscriber>(4);

        public SessionSubscriptionInfo(String sessionId) {
            Assert.notNull((Object)sessionId, (String)"'sessionId' must not be null");
            this.sessionId = sessionId;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public Set<String> getSubscriptions() {
            return this.subscriberLookup.keySet();
        }

        public GraphQLBrokerChannelSubscriber getSubscriber(String subscriptionId) {
            return this.subscriberLookup.get(subscriptionId);
        }

        public void addSubscription(String subscriptionId, GraphQLBrokerChannelSubscriber subscriber) {
            this.subscriberLookup.put(subscriptionId, subscriber);
        }

        public GraphQLBrokerChannelSubscriber removeSubscription(String destination) {
            return this.subscriberLookup.remove(destination);
        }

        public Collection<GraphQLBrokerChannelSubscriber> removeAll() {
            ArrayList<GraphQLBrokerChannelSubscriber> values = new ArrayList<GraphQLBrokerChannelSubscriber>(this.subscriberLookup.values());
            this.subscriberLookup.clear();
            return values;
        }

        public String toString() {
            return "[sessionId=" + this.sessionId + ", subscriptions=" + String.valueOf(this.subscriberLookup) + "]";
        }
    }
}

