/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.ws.transport;

import java.security.Principal;
import org.activiti.cloud.services.notifications.graphql.ws.api.GraphQLMessage;
import org.activiti.cloud.services.notifications.graphql.ws.transport.AbstractGraphQLSubProtocolEvent;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;

public class GraphQLSessionDisconnectEvent
extends AbstractGraphQLSubProtocolEvent {
    private final String sessionId;
    private final CloseStatus status;

    public GraphQLSessionDisconnectEvent(Object source, Message<GraphQLMessage> message, String sessionId, CloseStatus closeStatus) {
        this(source, message, sessionId, closeStatus, null);
    }

    public GraphQLSessionDisconnectEvent(Object source, Message<GraphQLMessage> message, String sessionId, CloseStatus closeStatus, Principal user) {
        super(source, message, user);
        Assert.notNull((Object)sessionId, (String)"Session id must not be null");
        this.sessionId = sessionId;
        this.status = closeStatus;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public CloseStatus getCloseStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        return "SessionDisconnectEvent[sessionId=" + this.sessionId + ", " + (this.status != null ? this.status.toString() : "closeStatus=null") + "]";
    }
}

