/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.ws.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

public class JsonConverter {
    static final ObjectMapper JSON = new ObjectMapper().configure(SerializationFeature.WRITE_NULL_MAP_VALUES, true).setSerializationInclusion(JsonInclude.Include.ALWAYS);

    public static Map<String, Object> toMap(String jsonStr) throws JsonParseException, JsonMappingException, IOException {
        if (jsonStr == null || jsonStr.trim().length() == 0) {
            return Collections.emptyMap();
        }
        Map map = (Map)JSON.readValue(jsonStr, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return map == null ? Collections.emptyMap() : map;
    }

    public static String toJsonString(Object obj) throws JsonProcessingException {
        return JSON.writeValueAsString(obj);
    }
}

