/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.ws.util;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.activiti.cloud.services.notifications.graphql.ws.util.JsonConverter;

public class QueryParameters {
    String query;
    String operationName;
    Map<String, Object> variables = Collections.emptyMap();

    public String getQuery() {
        return this.query;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public static QueryParameters from(String queryMessage) throws JsonParseException, JsonMappingException, IOException {
        Map<String, Object> json = JsonConverter.toMap(queryMessage);
        return QueryParameters.from(json);
    }

    public static QueryParameters from(Map<String, Object> json) throws JsonParseException, JsonMappingException, IOException {
        QueryParameters parameters = new QueryParameters();
        parameters.query = (String)json.get("query");
        parameters.operationName = (String)json.get("operationName");
        parameters.variables = QueryParameters.getVariables(json.get("variables"));
        return parameters;
    }

    private static Map<String, Object> getVariables(Object variables) throws JsonParseException, JsonMappingException, IOException {
        if (variables instanceof Map) {
            Map inputVars = (Map)variables;
            HashMap<String, Object> vars = new HashMap<String, Object>();
            inputVars.forEach((k, v) -> vars.put(String.valueOf(k), v));
            return vars;
        }
        return JsonConverter.toMap(String.valueOf(variables));
    }
}

