/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import org.activiti.api.process.model.ProcessDefinition;
import org.activiti.api.process.model.events.ProcessDefinitionEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.process.model.events.CloudProcessDeployedEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.ProcessDefinitionEntity;
import org.activiti.cloud.services.query.model.ProcessModelEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDeployedEventHandler
implements QueryEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessDeployedEventHandler.class);
    private EntityManager entityManager;

    public ProcessDeployedEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudProcessDeployedEvent processDeployedEvent = (CloudProcessDeployedEvent)CloudProcessDeployedEvent.class.cast(event);
        ProcessDefinition processDefinition = (ProcessDefinition)processDeployedEvent.getEntity();
        LOGGER.debug("Handling process deployed event for " + processDefinition.getKey());
        ProcessDefinitionEntity processDefinitionEntity = new ProcessDefinitionEntity(processDeployedEvent.getServiceName(), processDeployedEvent.getServiceFullName(), processDeployedEvent.getServiceVersion(), processDeployedEvent.getAppName(), processDeployedEvent.getAppVersion());
        processDefinitionEntity.setId(processDefinition.getId());
        processDefinitionEntity.setDescription(processDefinition.getDescription());
        processDefinitionEntity.setFormKey(processDefinition.getFormKey());
        processDefinitionEntity.setKey(processDefinition.getKey());
        processDefinitionEntity.setName(processDefinition.getName());
        processDefinitionEntity.setVersion(processDefinition.getVersion());
        processDefinitionEntity.setCategory(processDefinition.getCategory());
        processDefinitionEntity.setServiceType(processDeployedEvent.getServiceType());
        this.entityManager.merge((Object)processDefinitionEntity);
        ProcessModelEntity processModelEntity = new ProcessModelEntity(processDefinitionEntity, processDeployedEvent.getProcessModelContent());
        processModelEntity.setId(processDefinitionEntity.getId());
        this.entityManager.merge((Object)processModelEntity);
    }

    @Override
    public String getHandledEvent() {
        return ProcessDefinitionEvent.ProcessDefinitionEvents.PROCESS_DEPLOYED.name();
    }
}

