/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import jakarta.persistence.EntityManager;
import org.activiti.api.task.model.TaskCandidateUser;
import org.activiti.api.task.model.events.TaskCandidateUserEvent;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.task.model.events.CloudTaskCandidateUserAddedEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.activiti.cloud.services.query.model.QueryException;
import org.activiti.cloud.services.query.model.TaskCandidateUserEntity;
import org.activiti.cloud.services.query.model.TaskCandidateUserId;

public class TaskCandidateUserAddedEventHandler
implements QueryEventHandler {
    private final EntityManager entityManager;

    public TaskCandidateUserAddedEventHandler(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void handle(CloudRuntimeEvent<?, ?> event) {
        CloudTaskCandidateUserAddedEvent taskCandidateUserAddedEvent = (CloudTaskCandidateUserAddedEvent)event;
        TaskCandidateUser taskCandidateUser = (TaskCandidateUser)taskCandidateUserAddedEvent.getEntity();
        TaskCandidateUserEntity entity = new TaskCandidateUserEntity(taskCandidateUser.getTaskId(), taskCandidateUser.getUserId());
        try {
            if (!this.taskCandidateEntityAlreadyExists(entity)) {
                this.entityManager.persist((Object)entity);
            }
        }
        catch (Exception cause) {
            throw new QueryException("Error handling TaskCandidateUserAddedEvent[" + String.valueOf(event) + "]", (Throwable)cause);
        }
    }

    @Override
    public String getHandledEvent() {
        return TaskCandidateUserEvent.TaskCandidateUserEvents.TASK_CANDIDATE_USER_ADDED.name();
    }

    private boolean taskCandidateEntityAlreadyExists(TaskCandidateUserEntity entity) {
        return this.entityManager.find(TaskCandidateUserEntity.class, (Object)new TaskCandidateUserId(entity.getTaskId(), entity.getUserId())) != null;
    }
}

