/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import com.querydsl.core.annotations.PropertyType;
import com.querydsl.core.annotations.QueryType;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedEntityGraphs;
import jakarta.persistence.NamedSubgraph;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.cloud.api.process.model.QueryCloudProcessInstance;
import org.activiti.cloud.api.process.model.QueryCloudSubprocessInstance;
import org.activiti.cloud.services.query.model.ActivitiEntityMetadata;
import org.activiti.cloud.services.query.model.BPMNActivityEntity;
import org.activiti.cloud.services.query.model.BPMNSequenceFlowEntity;
import org.activiti.cloud.services.query.model.JsonViews;
import org.activiti.cloud.services.query.model.ProcessVariableEntity;
import org.activiti.cloud.services.query.model.ServiceTaskEntity;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Filter;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.springframework.format.annotation.DateTimeFormat;

@Entity(name="ProcessInstance")
@Table(name="PROCESS_INSTANCE", indexes={@Index(name="pi_status_idx", columnList="status", unique=false), @Index(name="pi_businessKey_idx", columnList="businessKey", unique=false), @Index(name="pi_name_idx", columnList="name", unique=false), @Index(name="pi_processDefinitionId_idx", columnList="processDefinitionId", unique=false), @Index(name="pi_processDefinitionKey_idx", columnList="processDefinitionKey", unique=false), @Index(name="pi_processDefinitionName_idx", columnList="processDefinitionName", unique=false)})
@DynamicInsert
@DynamicUpdate
@NamedEntityGraphs(value={@NamedEntityGraph(name="ProcessInstances.withVariables", attributeNodes={@NamedAttributeNode(value="variables", subgraph="variables")}, subgraphs={@NamedSubgraph(name="variables", attributeNodes={@NamedAttributeNode(value="value")})})})
@EnhancementInfo(version="6.6.3.Final")
public class ProcessInstanceEntity
extends ActivitiEntityMetadata
implements QueryCloudProcessInstance,
ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    @Id
    String id;
    String name;
    String processDefinitionId;
    @Schema(description="It identifies uniquely the process. In the BPMN process definition file it is the id attribute of a process and in the Modeling application it is usually called as Process ID.")
    String processDefinitionKey;
    String initiator;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    Date startDate;
    @Schema(description="The business key associated to the process instance. It could be useful to add a reference to external systems.", readOnly=true)
    String businessKey;
    @Enumerated(value=EnumType.STRING)
    ProcessInstance.ProcessInstanceStatus status;
    Integer processDefinitionVersion;
    String processDefinitionName;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    Date completedDate;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    Date suspendedDate;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    Date lastModified;
    @JsonIgnore
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModifiedTo;
    @JsonIgnore
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModifiedFrom;
    @JsonIgnore
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @QueryType(value=PropertyType.DATETIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date startFrom;
    @JsonIgnore
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @QueryType(value=PropertyType.DATETIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date startTo;
    @JsonIgnore
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @QueryType(value=PropertyType.DATETIME)
    @Transient
    private Date completedTo;
    @JsonIgnore
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @QueryType(value=PropertyType.DATETIME)
    @Transient
    private Date completedFrom;
    @JsonIgnore
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @QueryType(value=PropertyType.DATETIME)
    @Transient
    private Date suspendedTo;
    @JsonIgnore
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @QueryType(value=PropertyType.DATETIME)
    @Transient
    private Date suspendedFrom;
    @JsonIgnore
    @OneToMany(fetch=FetchType.LAZY)
    @JoinColumn(name="processInstanceId", referencedColumnName="id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT, name="none"))
    Set<TaskEntity> tasks;
    @JsonView(value={JsonViews.ProcessVariables.class})
    @Filter(name="variablesFilter")
    @OneToMany(fetch=FetchType.LAZY)
    @JoinColumn(name="processInstanceId", referencedColumnName="id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT, name="none"))
    Set<ProcessVariableEntity> variables;
    @JsonIgnore
    @OneToMany(fetch=FetchType.LAZY)
    @JoinColumn(name="processInstanceId", referencedColumnName="id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT, name="none"))
    Set<BPMNActivityEntity> activities;
    @JsonIgnore
    @OneToMany(fetch=FetchType.LAZY)
    @JoinColumn(name="processInstanceId", referencedColumnName="id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT, name="none"))
    List<ServiceTaskEntity> serviceTasks;
    @JsonIgnore
    @OneToMany(fetch=FetchType.LAZY)
    @JoinColumn(name="processInstanceId", referencedColumnName="id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT, name="none"))
    List<BPMNSequenceFlowEntity> sequenceFlows;
    String parentId;
    @Transient
    private Set<QueryCloudSubprocessInstance> subprocesses;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient boolean $$_hibernate_useTracker;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public ProcessInstanceEntity() {
        this.$$_hibernate_write_tasks(new LinkedHashSet());
        this.$$_hibernate_write_variables(new LinkedHashSet());
        this.$$_hibernate_write_activities(new LinkedHashSet());
        this.$$_hibernate_write_serviceTasks(new LinkedList());
        this.$$_hibernate_write_sequenceFlows(new LinkedList());
    }

    public ProcessInstanceEntity(String serviceName, String serviceFullName, String serviceVersion, String appName, String appVersion, String processInstanceId, String processDefinitionId, ProcessInstance.ProcessInstanceStatus status, Date lastModified) {
        super(serviceName, serviceFullName, serviceVersion, appName, appVersion);
        this.$$_hibernate_write_tasks(new LinkedHashSet());
        this.$$_hibernate_write_variables(new LinkedHashSet());
        this.$$_hibernate_write_activities(new LinkedHashSet());
        this.$$_hibernate_write_serviceTasks(new LinkedList());
        this.$$_hibernate_write_sequenceFlows(new LinkedList());
        this.$$_hibernate_write_id(processInstanceId);
        this.$$_hibernate_write_processDefinitionId(processDefinitionId);
        this.$$_hibernate_write_status(status);
        this.$$_hibernate_write_lastModified(lastModified);
    }

    public String getProcessDefinitionId() {
        return this.$$_hibernate_read_processDefinitionId();
    }

    public ProcessInstance.ProcessInstanceStatus getStatus() {
        return this.$$_hibernate_read_status();
    }

    public Date getLastModified() {
        return this.$$_hibernate_read_lastModified();
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.$$_hibernate_write_processDefinitionId(processDefinitionId);
    }

    public void setStatus(ProcessInstance.ProcessInstanceStatus status) {
        this.$$_hibernate_write_status(status);
    }

    public void setLastModified(Date lastModified) {
        this.$$_hibernate_write_lastModified(lastModified);
    }

    @Transient
    public Date getLastModifiedTo() {
        return this.lastModifiedTo;
    }

    public void setLastModifiedTo(Date lastModifiedTo) {
        this.lastModifiedTo = lastModifiedTo;
    }

    @Transient
    public Date getLastModifiedFrom() {
        return this.lastModifiedFrom;
    }

    public void setLastModifiedFrom(Date lastModifiedFrom) {
        this.lastModifiedFrom = lastModifiedFrom;
    }

    public Set<TaskEntity> getTasks() {
        return this.$$_hibernate_read_tasks();
    }

    public void setTasks(Set<TaskEntity> tasks) {
        this.$$_hibernate_write_tasks(tasks);
    }

    public Set<ProcessVariableEntity> getVariables() {
        return this.$$_hibernate_read_variables();
    }

    public void setVariables(Set<ProcessVariableEntity> variable) {
        this.$$_hibernate_write_variables(variable);
    }

    public Optional<ProcessVariableEntity> getVariable(String variableName) {
        return this.getVariables().stream().filter(v -> v.getName().equals(variableName)).findFirst();
    }

    public Optional<BPMNSequenceFlowEntity> getSequenceFlowByEventId(String eventId) {
        return this.getSequenceFlows().stream().filter(v -> eventId.equals(v.getEventId())).findFirst();
    }

    public String getProcessDefinitionKey() {
        return this.$$_hibernate_read_processDefinitionKey();
    }

    public String getParentId() {
        return this.$$_hibernate_read_parentId();
    }

    public void setParentId(String parentId) {
        this.$$_hibernate_write_parentId(parentId);
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.$$_hibernate_write_processDefinitionKey(processDefinitionKey);
    }

    public String getId() {
        return this.$$_hibernate_read_id();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id);
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public void setName(String name) {
        this.$$_hibernate_write_name(name);
    }

    public String getInitiator() {
        return this.$$_hibernate_read_initiator();
    }

    public void setInitiator(String initiator) {
        this.$$_hibernate_write_initiator(initiator);
    }

    public Date getStartDate() {
        return this.$$_hibernate_read_startDate();
    }

    public void setStartDate(Date startDate) {
        this.$$_hibernate_write_startDate(startDate);
    }

    public String getBusinessKey() {
        return this.$$_hibernate_read_businessKey();
    }

    public void setBusinessKey(String businessKey) {
        this.$$_hibernate_write_businessKey(businessKey);
    }

    public Integer getProcessDefinitionVersion() {
        return this.$$_hibernate_read_processDefinitionVersion();
    }

    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.$$_hibernate_write_processDefinitionVersion(processDefinitionVersion);
    }

    public String getProcessDefinitionName() {
        return this.$$_hibernate_read_processDefinitionName();
    }

    public void setProcessDefinitionName(String processDefinitionName) {
        this.$$_hibernate_write_processDefinitionName(processDefinitionName);
    }

    @Transient
    public Date getStartFrom() {
        return this.startFrom;
    }

    public void setStartFrom(Date startFrom) {
        this.startFrom = startFrom;
    }

    @Transient
    public Date getStartTo() {
        return this.startTo;
    }

    public void setStartTo(Date startTo) {
        this.startTo = startTo;
    }

    public Date getCompletedDate() {
        return this.$$_hibernate_read_completedDate();
    }

    public void setCompletedDate(Date endDate) {
        this.$$_hibernate_write_completedDate(endDate);
    }

    public Date getCompletedTo() {
        return this.completedTo;
    }

    public void setCompletedTo(Date completedTo) {
        this.completedTo = completedTo;
    }

    public Date getCompletedFrom() {
        return this.completedFrom;
    }

    public void setCompletedFrom(Date completedFrom) {
        this.completedFrom = completedFrom;
    }

    public Date getSuspendedDate() {
        return this.$$_hibernate_read_suspendedDate();
    }

    public void setSuspendedDate(Date suspendedDate) {
        this.$$_hibernate_write_suspendedDate(suspendedDate);
    }

    public Date getSuspendedTo() {
        return this.suspendedTo;
    }

    public void setSuspendedTo(Date suspendedTo) {
        this.suspendedTo = suspendedTo;
    }

    public Date getSuspendedFrom() {
        return this.suspendedFrom;
    }

    public void setSuspendedFrom(Date suspendedFrom) {
        this.suspendedFrom = suspendedFrom;
    }

    public boolean isInFinalState() {
        return !ProcessInstance.ProcessInstanceStatus.CREATED.equals((Object)this.$$_hibernate_read_status()) && !ProcessInstance.ProcessInstanceStatus.RUNNING.equals((Object)this.$$_hibernate_read_status()) && !ProcessInstance.ProcessInstanceStatus.SUSPENDED.equals((Object)this.$$_hibernate_read_status());
    }

    public Set<BPMNActivityEntity> getActivities() {
        return this.$$_hibernate_read_activities();
    }

    public void setActivities(Set<BPMNActivityEntity> bpmnActivities) {
        this.$$_hibernate_write_activities(bpmnActivities);
    }

    public List<ServiceTaskEntity> getServiceTasks() {
        return this.$$_hibernate_read_serviceTasks();
    }

    public void setServiceTasks(List<ServiceTaskEntity> serviceTasks) {
        this.$$_hibernate_write_serviceTasks(serviceTasks);
    }

    public List<BPMNSequenceFlowEntity> getSequenceFlows() {
        return this.$$_hibernate_read_sequenceFlows();
    }

    public void setSequenceFlows(List<BPMNSequenceFlowEntity> sequenceFlows) {
        this.$$_hibernate_write_sequenceFlows(sequenceFlows);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessInstanceEntity other = (ProcessInstanceEntity)obj;
        return this.$$_hibernate_read_id() != null && Objects.equals(this.$$_hibernate_read_id(), other.$$_hibernate_read_id());
    }

    public Set<QueryCloudSubprocessInstance> getSubprocesses() {
        return this.subprocesses;
    }

    public void setSubprocesses(Set<QueryCloudSubprocessInstance> subprocesses) {
        this.subprocesses = subprocesses;
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public boolean $$_hibernate_useTracker() {
        return this.$$_hibernate_useTracker;
    }

    public void $$_hibernate_setUseTracker(boolean bl) {
        this.$$_hibernate_useTracker = bl;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        ProcessInstanceEntity processInstanceEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        int n;
        block16: {
            int n2;
            block17: {
                int n3;
                int n4;
                ProcessInstanceEntity processInstanceEntity = this;
                ProcessInstanceEntity processInstanceEntity2 = processInstanceEntity;
                ProcessInstanceEntity processInstanceEntity3 = processInstanceEntity2;
                ProcessInstanceEntity processInstanceEntity4 = processInstanceEntity3;
                ProcessInstanceEntity processInstanceEntity5 = processInstanceEntity4;
                int n5 = 0;
                if (n5 == 0 && processInstanceEntity4.$$_hibernate_collectionTracker != null) {
                    int n6 = processInstanceEntity4.$$_hibernate_collectionTracker.getSize("tasks");
                    if (processInstanceEntity4.tasks == null && n6 != -1) {
                        n5 = 1;
                    } else if (processInstanceEntity4.tasks != null && (!(processInstanceEntity4.tasks instanceof PersistentCollection) || ((PersistentCollection)processInstanceEntity4.tasks).wasInitialized()) && n6 != processInstanceEntity4.tasks.size()) {
                        n5 = 1;
                    }
                }
                if ((n4 = n5) == 0 && processInstanceEntity3.$$_hibernate_collectionTracker != null) {
                    n5 = processInstanceEntity3.$$_hibernate_collectionTracker.getSize("variables");
                    if (processInstanceEntity3.variables == null && n5 != -1) {
                        n4 = 1;
                    } else if (processInstanceEntity3.variables != null && (!(processInstanceEntity3.variables instanceof PersistentCollection) || ((PersistentCollection)processInstanceEntity3.variables).wasInitialized()) && n5 != processInstanceEntity3.variables.size()) {
                        n4 = 1;
                    }
                }
                if ((n3 = n4) == 0 && processInstanceEntity2.$$_hibernate_collectionTracker != null) {
                    n4 = processInstanceEntity2.$$_hibernate_collectionTracker.getSize("activities");
                    if (processInstanceEntity2.activities == null && n4 != -1) {
                        n3 = 1;
                    } else if (processInstanceEntity2.activities != null && (!(processInstanceEntity2.activities instanceof PersistentCollection) || ((PersistentCollection)processInstanceEntity2.activities).wasInitialized()) && n4 != processInstanceEntity2.activities.size()) {
                        n3 = 1;
                    }
                }
                if ((n2 = n3) == 0 && processInstanceEntity.$$_hibernate_collectionTracker != null) {
                    n3 = processInstanceEntity.$$_hibernate_collectionTracker.getSize("serviceTasks");
                    if (processInstanceEntity.serviceTasks == null && n3 != -1) {
                        n2 = 1;
                    } else if (processInstanceEntity.serviceTasks != null && (!(processInstanceEntity.serviceTasks instanceof PersistentCollection) || ((PersistentCollection)processInstanceEntity.serviceTasks).wasInitialized()) && n3 != processInstanceEntity.serviceTasks.size()) {
                        n2 = 1;
                    }
                }
                if ((n = n2) != 0 || this.$$_hibernate_collectionTracker == null) break block16;
                n2 = this.$$_hibernate_collectionTracker.getSize("sequenceFlows");
                if (this.sequenceFlows != null || n2 == -1) break block17;
                n = 1;
                break block16;
            }
            if (this.sequenceFlows == null || this.sequenceFlows instanceof PersistentCollection && !((PersistentCollection)this.sequenceFlows).wasInitialized() || n2 == this.sequenceFlows.size()) break block16;
            n = 1;
        }
        return n != 0;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block16: {
            int n;
            block17: {
                ProcessInstanceEntity processInstanceEntity = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                ProcessInstanceEntity processInstanceEntity2 = processInstanceEntity;
                DirtyTracker dirtyTracker3 = dirtyTracker2;
                ProcessInstanceEntity processInstanceEntity3 = processInstanceEntity2;
                DirtyTracker dirtyTracker4 = dirtyTracker3;
                ProcessInstanceEntity processInstanceEntity4 = processInstanceEntity3;
                DirtyTracker dirtyTracker5 = dirtyTracker4;
                ProcessInstanceEntity processInstanceEntity5 = processInstanceEntity4;
                DirtyTracker dirtyTracker6 = dirtyTracker5;
                if (processInstanceEntity4.$$_hibernate_collectionTracker != null) {
                    int n2 = processInstanceEntity4.$$_hibernate_collectionTracker.getSize("tasks");
                    if (processInstanceEntity4.tasks == null && n2 != -1) {
                        dirtyTracker5.add("tasks");
                    } else if (processInstanceEntity4.tasks != null && (!(processInstanceEntity4.tasks instanceof PersistentCollection) || ((PersistentCollection)processInstanceEntity4.tasks).wasInitialized()) && n2 != processInstanceEntity4.tasks.size()) {
                        dirtyTracker5.add("tasks");
                    }
                }
                if (processInstanceEntity3.$$_hibernate_collectionTracker != null) {
                    int n3 = processInstanceEntity3.$$_hibernate_collectionTracker.getSize("variables");
                    if (processInstanceEntity3.variables == null && n3 != -1) {
                        dirtyTracker4.add("variables");
                    } else if (processInstanceEntity3.variables != null && (!(processInstanceEntity3.variables instanceof PersistentCollection) || ((PersistentCollection)processInstanceEntity3.variables).wasInitialized()) && n3 != processInstanceEntity3.variables.size()) {
                        dirtyTracker4.add("variables");
                    }
                }
                if (processInstanceEntity2.$$_hibernate_collectionTracker != null) {
                    int n4 = processInstanceEntity2.$$_hibernate_collectionTracker.getSize("activities");
                    if (processInstanceEntity2.activities == null && n4 != -1) {
                        dirtyTracker3.add("activities");
                    } else if (processInstanceEntity2.activities != null && (!(processInstanceEntity2.activities instanceof PersistentCollection) || ((PersistentCollection)processInstanceEntity2.activities).wasInitialized()) && n4 != processInstanceEntity2.activities.size()) {
                        dirtyTracker3.add("activities");
                    }
                }
                if (processInstanceEntity.$$_hibernate_collectionTracker != null) {
                    int n5 = processInstanceEntity.$$_hibernate_collectionTracker.getSize("serviceTasks");
                    if (processInstanceEntity.serviceTasks == null && n5 != -1) {
                        dirtyTracker2.add("serviceTasks");
                    } else if (processInstanceEntity.serviceTasks != null && (!(processInstanceEntity.serviceTasks instanceof PersistentCollection) || ((PersistentCollection)processInstanceEntity.serviceTasks).wasInitialized()) && n5 != processInstanceEntity.serviceTasks.size()) {
                        dirtyTracker2.add("serviceTasks");
                    }
                }
                if (this.$$_hibernate_collectionTracker == null) break block16;
                n = this.$$_hibernate_collectionTracker.getSize("sequenceFlows");
                if (this.sequenceFlows != null || n == -1) break block17;
                dirtyTracker.add("sequenceFlows");
                break block16;
            }
            if (this.sequenceFlows == null || this.sequenceFlows instanceof PersistentCollection && !((PersistentCollection)this.sequenceFlows).wasInitialized() || n == this.sequenceFlows.size()) break block16;
            dirtyTracker.add("sequenceFlows");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block15: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            ProcessInstanceEntity processInstanceEntity = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            ProcessInstanceEntity processInstanceEntity2 = processInstanceEntity;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor3 = lazyAttributeLoadingInterceptor2;
            ProcessInstanceEntity processInstanceEntity3 = processInstanceEntity2;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor4 = lazyAttributeLoadingInterceptor3;
            ProcessInstanceEntity processInstanceEntity4 = processInstanceEntity3;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor5 = lazyAttributeLoadingInterceptor4;
            ProcessInstanceEntity processInstanceEntity5 = processInstanceEntity4;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor6 = lazyAttributeLoadingInterceptor5;
            if (lazyAttributeLoadingInterceptor5 == null || lazyAttributeLoadingInterceptor5.isAttributeLoaded("tasks")) {
                if (processInstanceEntity4.tasks == null || processInstanceEntity4.tasks instanceof PersistentCollection && !((PersistentCollection)processInstanceEntity4.tasks).wasInitialized()) {
                    processInstanceEntity4.$$_hibernate_collectionTracker.add("tasks", -1);
                } else {
                    processInstanceEntity4.$$_hibernate_collectionTracker.add("tasks", processInstanceEntity4.tasks.size());
                }
            }
            if (lazyAttributeLoadingInterceptor4 == null || lazyAttributeLoadingInterceptor4.isAttributeLoaded("variables")) {
                if (processInstanceEntity3.variables == null || processInstanceEntity3.variables instanceof PersistentCollection && !((PersistentCollection)processInstanceEntity3.variables).wasInitialized()) {
                    processInstanceEntity3.$$_hibernate_collectionTracker.add("variables", -1);
                } else {
                    processInstanceEntity3.$$_hibernate_collectionTracker.add("variables", processInstanceEntity3.variables.size());
                }
            }
            if (lazyAttributeLoadingInterceptor3 == null || lazyAttributeLoadingInterceptor3.isAttributeLoaded("activities")) {
                if (processInstanceEntity2.activities == null || processInstanceEntity2.activities instanceof PersistentCollection && !((PersistentCollection)processInstanceEntity2.activities).wasInitialized()) {
                    processInstanceEntity2.$$_hibernate_collectionTracker.add("activities", -1);
                } else {
                    processInstanceEntity2.$$_hibernate_collectionTracker.add("activities", processInstanceEntity2.activities.size());
                }
            }
            if (lazyAttributeLoadingInterceptor2 == null || lazyAttributeLoadingInterceptor2.isAttributeLoaded("serviceTasks")) {
                if (processInstanceEntity.serviceTasks == null || processInstanceEntity.serviceTasks instanceof PersistentCollection && !((PersistentCollection)processInstanceEntity.serviceTasks).wasInitialized()) {
                    processInstanceEntity.$$_hibernate_collectionTracker.add("serviceTasks", -1);
                } else {
                    processInstanceEntity.$$_hibernate_collectionTracker.add("serviceTasks", processInstanceEntity.serviceTasks.size());
                }
            }
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("sequenceFlows")) break block15;
            if (this.sequenceFlows == null || this.sequenceFlows instanceof PersistentCollection && !((PersistentCollection)this.sequenceFlows).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("sequenceFlows", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("sequenceFlows", this.sequenceFlows.size());
            }
        }
    }

    @Override
    public String $$_hibernate_read_serviceName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceName", (Object)this.serviceName);
        }
        return this.serviceName;
    }

    @Override
    public void $$_hibernate_write_serviceName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceName", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_serviceName())) {
            this.$$_hibernate_trackChange("serviceName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceName", (Object)this.serviceName, (Object)string);
            return;
        }
        this.serviceName = string;
    }

    @Override
    public String $$_hibernate_read_serviceFullName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceFullName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceFullName", (Object)this.serviceFullName);
        }
        return this.serviceFullName;
    }

    @Override
    public void $$_hibernate_write_serviceFullName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceFullName", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_serviceFullName())) {
            this.$$_hibernate_trackChange("serviceFullName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceFullName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceFullName", (Object)this.serviceFullName, (Object)string);
            return;
        }
        this.serviceFullName = string;
    }

    @Override
    public String $$_hibernate_read_serviceVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceVersion = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceVersion", (Object)this.serviceVersion);
        }
        return this.serviceVersion;
    }

    @Override
    public void $$_hibernate_write_serviceVersion(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceVersion", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_serviceVersion())) {
            this.$$_hibernate_trackChange("serviceVersion");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceVersion = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceVersion", (Object)this.serviceVersion, (Object)string);
            return;
        }
        this.serviceVersion = string;
    }

    @Override
    public String $$_hibernate_read_appName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.appName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "appName", (Object)this.appName);
        }
        return this.appName;
    }

    @Override
    public void $$_hibernate_write_appName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"appName", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_appName())) {
            this.$$_hibernate_trackChange("appName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.appName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "appName", (Object)this.appName, (Object)string);
            return;
        }
        this.appName = string;
    }

    @Override
    public String $$_hibernate_read_appVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.appVersion = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "appVersion", (Object)this.appVersion);
        }
        return this.appVersion;
    }

    @Override
    public void $$_hibernate_write_appVersion(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"appVersion", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_appVersion())) {
            this.$$_hibernate_trackChange("appVersion");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.appVersion = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "appVersion", (Object)this.appVersion, (Object)string);
            return;
        }
        this.appVersion = string;
    }

    @Override
    public String $$_hibernate_read_serviceType() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceType = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceType", (Object)this.serviceType);
        }
        return this.serviceType;
    }

    @Override
    public void $$_hibernate_write_serviceType(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceType", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_serviceType())) {
            this.$$_hibernate_trackChange("serviceType");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceType = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceType", (Object)this.serviceType, (Object)string);
            return;
        }
        this.serviceType = string;
    }

    public String $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)string);
            return;
        }
        this.id = string;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"name", (Object)string, (Object)this.name)) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public String $$_hibernate_read_processDefinitionId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "processDefinitionId", (Object)this.processDefinitionId);
        }
        return this.processDefinitionId;
    }

    public void $$_hibernate_write_processDefinitionId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"processDefinitionId", (Object)string, (Object)this.processDefinitionId)) {
            this.$$_hibernate_trackChange("processDefinitionId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processDefinitionId", (Object)this.processDefinitionId, (Object)string);
            return;
        }
        this.processDefinitionId = string;
    }

    public String $$_hibernate_read_processDefinitionKey() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionKey = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "processDefinitionKey", (Object)this.processDefinitionKey);
        }
        return this.processDefinitionKey;
    }

    public void $$_hibernate_write_processDefinitionKey(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"processDefinitionKey", (Object)string, (Object)this.processDefinitionKey)) {
            this.$$_hibernate_trackChange("processDefinitionKey");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionKey = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processDefinitionKey", (Object)this.processDefinitionKey, (Object)string);
            return;
        }
        this.processDefinitionKey = string;
    }

    public String $$_hibernate_read_initiator() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.initiator = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "initiator", (Object)this.initiator);
        }
        return this.initiator;
    }

    public void $$_hibernate_write_initiator(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"initiator", (Object)string, (Object)this.initiator)) {
            this.$$_hibernate_trackChange("initiator");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.initiator = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "initiator", (Object)this.initiator, (Object)string);
            return;
        }
        this.initiator = string;
    }

    public Date $$_hibernate_read_startDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.startDate = (Date)this.$$_hibernate_getInterceptor().readObject((Object)this, "startDate", (Object)this.startDate);
        }
        return this.startDate;
    }

    public void $$_hibernate_write_startDate(Date date) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"startDate", (Object)date, (Object)this.startDate)) {
            this.$$_hibernate_trackChange("startDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.startDate = (Date)this.$$_hibernate_getInterceptor().writeObject((Object)this, "startDate", (Object)this.startDate, (Object)date);
            return;
        }
        this.startDate = date;
    }

    public String $$_hibernate_read_businessKey() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.businessKey = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "businessKey", (Object)this.businessKey);
        }
        return this.businessKey;
    }

    public void $$_hibernate_write_businessKey(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"businessKey", (Object)string, (Object)this.businessKey)) {
            this.$$_hibernate_trackChange("businessKey");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.businessKey = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "businessKey", (Object)this.businessKey, (Object)string);
            return;
        }
        this.businessKey = string;
    }

    public ProcessInstance.ProcessInstanceStatus $$_hibernate_read_status() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.status = (ProcessInstance.ProcessInstanceStatus)this.$$_hibernate_getInterceptor().readObject((Object)this, "status", (Object)this.status);
        }
        return this.status;
    }

    public void $$_hibernate_write_status(ProcessInstance.ProcessInstanceStatus processInstanceStatus) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"status", (Object)processInstanceStatus, (Object)this.status)) {
            this.$$_hibernate_trackChange("status");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.status = (ProcessInstance.ProcessInstanceStatus)this.$$_hibernate_getInterceptor().writeObject((Object)this, "status", (Object)this.status, (Object)processInstanceStatus);
            return;
        }
        this.status = processInstanceStatus;
    }

    public Integer $$_hibernate_read_processDefinitionVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionVersion = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "processDefinitionVersion", (Object)this.processDefinitionVersion);
        }
        return this.processDefinitionVersion;
    }

    public void $$_hibernate_write_processDefinitionVersion(Integer n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"processDefinitionVersion", (Object)n, (Object)this.processDefinitionVersion)) {
            this.$$_hibernate_trackChange("processDefinitionVersion");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionVersion = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processDefinitionVersion", (Object)this.processDefinitionVersion, (Object)n);
            return;
        }
        this.processDefinitionVersion = n;
    }

    public String $$_hibernate_read_processDefinitionName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "processDefinitionName", (Object)this.processDefinitionName);
        }
        return this.processDefinitionName;
    }

    public void $$_hibernate_write_processDefinitionName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"processDefinitionName", (Object)string, (Object)this.processDefinitionName)) {
            this.$$_hibernate_trackChange("processDefinitionName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processDefinitionName", (Object)this.processDefinitionName, (Object)string);
            return;
        }
        this.processDefinitionName = string;
    }

    public Date $$_hibernate_read_completedDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.completedDate = (Date)this.$$_hibernate_getInterceptor().readObject((Object)this, "completedDate", (Object)this.completedDate);
        }
        return this.completedDate;
    }

    public void $$_hibernate_write_completedDate(Date date) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"completedDate", (Object)date, (Object)this.completedDate)) {
            this.$$_hibernate_trackChange("completedDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.completedDate = (Date)this.$$_hibernate_getInterceptor().writeObject((Object)this, "completedDate", (Object)this.completedDate, (Object)date);
            return;
        }
        this.completedDate = date;
    }

    public Date $$_hibernate_read_suspendedDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.suspendedDate = (Date)this.$$_hibernate_getInterceptor().readObject((Object)this, "suspendedDate", (Object)this.suspendedDate);
        }
        return this.suspendedDate;
    }

    public void $$_hibernate_write_suspendedDate(Date date) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"suspendedDate", (Object)date, (Object)this.suspendedDate)) {
            this.$$_hibernate_trackChange("suspendedDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.suspendedDate = (Date)this.$$_hibernate_getInterceptor().writeObject((Object)this, "suspendedDate", (Object)this.suspendedDate, (Object)date);
            return;
        }
        this.suspendedDate = date;
    }

    public Date $$_hibernate_read_lastModified() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastModified = (Date)this.$$_hibernate_getInterceptor().readObject((Object)this, "lastModified", (Object)this.lastModified);
        }
        return this.lastModified;
    }

    public void $$_hibernate_write_lastModified(Date date) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"lastModified", (Object)date, (Object)this.lastModified)) {
            this.$$_hibernate_trackChange("lastModified");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastModified = (Date)this.$$_hibernate_getInterceptor().writeObject((Object)this, "lastModified", (Object)this.lastModified, (Object)date);
            return;
        }
        this.lastModified = date;
    }

    public Set $$_hibernate_read_tasks() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.tasks = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "tasks", this.tasks);
        }
        return this.tasks;
    }

    public void $$_hibernate_write_tasks(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.tasks = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "tasks", this.tasks, (Object)set);
            return;
        }
        this.tasks = set;
    }

    public Set $$_hibernate_read_variables() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.variables = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "variables", this.variables);
        }
        return this.variables;
    }

    public void $$_hibernate_write_variables(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.variables = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "variables", this.variables, (Object)set);
            return;
        }
        this.variables = set;
    }

    public Set $$_hibernate_read_activities() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.activities = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "activities", this.activities);
        }
        return this.activities;
    }

    public void $$_hibernate_write_activities(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.activities = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "activities", this.activities, (Object)set);
            return;
        }
        this.activities = set;
    }

    public List $$_hibernate_read_serviceTasks() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceTasks = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceTasks", this.serviceTasks);
        }
        return this.serviceTasks;
    }

    public void $$_hibernate_write_serviceTasks(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceTasks = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceTasks", this.serviceTasks, (Object)list);
            return;
        }
        this.serviceTasks = list;
    }

    public List $$_hibernate_read_sequenceFlows() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.sequenceFlows = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "sequenceFlows", this.sequenceFlows);
        }
        return this.sequenceFlows;
    }

    public void $$_hibernate_write_sequenceFlows(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.sequenceFlows = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "sequenceFlows", this.sequenceFlows, (Object)list);
            return;
        }
        this.sequenceFlows = list;
    }

    public String $$_hibernate_read_parentId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.parentId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "parentId", (Object)this.parentId);
        }
        return this.parentId;
    }

    public void $$_hibernate_write_parentId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"parentId", (Object)string, (Object)this.parentId)) {
            this.$$_hibernate_trackChange("parentId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.parentId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "parentId", (Object)this.parentId, (Object)string);
            return;
        }
        this.parentId = string;
    }
}

