/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.Convert;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Objects;
import org.activiti.cloud.api.model.shared.CloudVariableInstance;
import org.activiti.cloud.services.query.model.ActivitiEntityMetadata;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.VariableValue;
import org.activiti.cloud.services.query.model.VariableValueJsonConverter;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.ManagedMappedSuperclass;
import org.springframework.format.annotation.DateTimeFormat;

@MappedSuperclass
@EnhancementInfo(version="6.6.3.Final")
public abstract class AbstractVariableEntity
extends ActivitiEntityMetadata
implements CloudVariableInstance,
ManagedMappedSuperclass {
    String type;
    String name;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @Temporal(value=TemporalType.TIMESTAMP)
    Date createTime;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    @Temporal(value=TemporalType.TIMESTAMP)
    Date lastUpdatedTime;
    String executionId;
    @Convert(converter=VariableValueJsonConverter.class)
    @JdbcTypeCode(value=3001)
    @Column(name="`value`", columnDefinition="jsonb")
    @Basic(fetch=FetchType.LAZY)
    VariableValue<?> value;
    Boolean markedAsDeleted;
    String processInstanceId;
    @JsonIgnore
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="processInstanceId", referencedColumnName="id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT, name="none"))
    ProcessInstanceEntity processInstance;

    public AbstractVariableEntity() {
        this.$$_hibernate_write_markedAsDeleted(false);
    }

    public AbstractVariableEntity(String type, String name, String processInstanceId, String serviceName, String serviceFullName, String serviceVersion, String appName, String appVersion, Date createTime, Date lastUpdatedTime, String executionId) {
        super(serviceName, serviceFullName, serviceVersion, appName, appVersion);
        this.$$_hibernate_write_markedAsDeleted(false);
        this.$$_hibernate_write_type(type);
        this.$$_hibernate_write_name(name);
        this.$$_hibernate_write_processInstanceId(processInstanceId);
        this.$$_hibernate_write_createTime(createTime);
        this.$$_hibernate_write_lastUpdatedTime(lastUpdatedTime);
        this.$$_hibernate_write_executionId(executionId);
    }

    public abstract Long getId();

    public String getType() {
        return this.$$_hibernate_read_type();
    }

    public void setType(String type) {
        this.$$_hibernate_write_type(type);
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public void setName(String name) {
        this.$$_hibernate_write_name(name);
    }

    public Date getCreateTime() {
        return this.$$_hibernate_read_createTime();
    }

    public void setCreateTime(Date createTime) {
        this.$$_hibernate_write_createTime(createTime);
    }

    public Date getLastUpdatedTime() {
        return this.$$_hibernate_read_lastUpdatedTime();
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.$$_hibernate_write_lastUpdatedTime(lastUpdatedTime);
    }

    public String getExecutionId() {
        return this.$$_hibernate_read_executionId();
    }

    public void setExecutionId(String executionId) {
        this.$$_hibernate_write_executionId(executionId);
    }

    public <T> void setValue(T value) {
        this.$$_hibernate_write_value(new VariableValue<T>(value));
    }

    public <T> T getValue() {
        return this.$$_hibernate_read_value().getValue();
    }

    public Boolean getMarkedAsDeleted() {
        return this.$$_hibernate_read_markedAsDeleted();
    }

    public void setMarkedAsDeleted(Boolean markedAsDeleted) {
        this.$$_hibernate_write_markedAsDeleted(markedAsDeleted);
    }

    public String getProcessInstanceId() {
        return this.$$_hibernate_read_processInstanceId();
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.$$_hibernate_write_processInstanceId(processInstanceId);
    }

    public ProcessInstanceEntity getProcessInstance() {
        return this.$$_hibernate_read_processInstance();
    }

    public void setProcessInstance(ProcessInstanceEntity processInstance) {
        this.$$_hibernate_write_processInstance(processInstance);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractVariableEntity other = (AbstractVariableEntity)obj;
        return this.getId() != null && Objects.equals(this.getId(), other.getId());
    }

    public String $$_hibernate_read_type() {
        return this.type;
    }

    public void $$_hibernate_write_type(String string) {
        this.type = string;
    }

    public String $$_hibernate_read_name() {
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        this.name = string;
    }

    public Date $$_hibernate_read_createTime() {
        return this.createTime;
    }

    public void $$_hibernate_write_createTime(Date date) {
        this.createTime = date;
    }

    public Date $$_hibernate_read_lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void $$_hibernate_write_lastUpdatedTime(Date date) {
        this.lastUpdatedTime = date;
    }

    public String $$_hibernate_read_executionId() {
        return this.executionId;
    }

    public void $$_hibernate_write_executionId(String string) {
        this.executionId = string;
    }

    public VariableValue $$_hibernate_read_value() {
        return this.value;
    }

    public void $$_hibernate_write_value(VariableValue variableValue) {
        this.value = variableValue;
    }

    public Boolean $$_hibernate_read_markedAsDeleted() {
        return this.markedAsDeleted;
    }

    public void $$_hibernate_write_markedAsDeleted(Boolean bl) {
        this.markedAsDeleted = bl;
    }

    public String $$_hibernate_read_processInstanceId() {
        return this.processInstanceId;
    }

    public void $$_hibernate_write_processInstanceId(String string) {
        this.processInstanceId = string;
    }

    public ProcessInstanceEntity $$_hibernate_read_processInstance() {
        return this.processInstance;
    }

    public void $$_hibernate_write_processInstance(ProcessInstanceEntity processInstanceEntity) {
        this.processInstance = processInstanceEntity;
    }
}

