/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonView;
import com.querydsl.core.annotations.PropertyType;
import com.querydsl.core.annotations.QueryType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.ConstraintMode;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.activiti.api.process.model.ProcessInstance;
import org.activiti.api.task.model.Task;
import org.activiti.cloud.api.task.model.QueryCloudTask;
import org.activiti.cloud.api.task.model.events.CloudTaskCreatedEvent;
import org.activiti.cloud.services.query.model.ActivitiEntityMetadata;
import org.activiti.cloud.services.query.model.JsonViews;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.ProcessVariableEntity;
import org.activiti.cloud.services.query.model.TaskCandidateGroupEntity;
import org.activiti.cloud.services.query.model.TaskCandidateUserEntity;
import org.activiti.cloud.services.query.model.TaskVariableEntity;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.springframework.format.annotation.DateTimeFormat;

@Entity(name="Task")
@Table(name="TASK", indexes={@Index(name="task_status_idx", columnList="status", unique=false), @Index(name="task_processInstance_idx", columnList="processInstanceId", unique=false), @Index(name="task_processDefinitionName_idx", columnList="processDefinitionName", unique=false)})
@DynamicInsert
@DynamicUpdate
@EnhancementInfo(version="6.6.3.Final")
public class TaskEntity
extends ActivitiEntityMetadata
implements QueryCloudTask,
Serializable,
ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    private static final long serialVersionUID = 1L;
    @Id
    String id;
    String assignee;
    String name;
    String description;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    Date createdDate;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    Date dueDate;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    Date claimedDate;
    int priority;
    String processDefinitionId;
    @Column(nullable=true, insertable=true, updatable=false)
    String processInstanceId;
    Integer processDefinitionVersion;
    String processDefinitionName;
    String businessKey;
    String taskDefinitionKey;
    String completedBy;
    @Enumerated(value=EnumType.STRING)
    Task.TaskStatus status;
    String owner;
    String parentTaskId;
    String formKey;
    private Date completedDate;
    Long duration;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    Date lastModified;
    @JsonIgnore
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdTo;
    @JsonIgnore
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdFrom;
    @JsonIgnore
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModifiedTo;
    @JsonIgnore
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModifiedFrom;
    @JsonIgnore
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastClaimedTo;
    @JsonIgnore
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastClaimedFrom;
    @JsonIgnore
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date completedTo;
    @JsonIgnore
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date completedFrom;
    @JsonIgnore
    @Transient
    @QueryType(value=PropertyType.DATETIME)
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dueDateTo;
    @JsonIgnore
    @Transient
    @QueryType(value=PropertyType.DATETIME)
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dueDateFrom;
    @JsonIgnore
    @Transient
    @QueryType(value=PropertyType.STRING)
    private String candidateGroupId;
    @Transient
    private List<QueryCloudTask.TaskPermissions> permissions;
    @JsonIgnore
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="processInstanceId", referencedColumnName="id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT, name="none"))
    ProcessInstanceEntity processInstance;
    @JsonIgnore
    @OneToMany(fetch=FetchType.LAZY)
    @JoinColumn(name="taskId", referencedColumnName="id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT, name="none"))
    @Fetch(value=FetchMode.SUBSELECT)
    Set<TaskCandidateUserEntity> taskCandidateUsers;
    @JsonIgnore
    @OneToMany(fetch=FetchType.LAZY)
    @JoinColumn(name="taskId", referencedColumnName="id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT, name="none"))
    @Fetch(value=FetchMode.SUBSELECT)
    Set<TaskCandidateGroupEntity> taskCandidateGroups;
    @JsonIgnore
    @OneToMany(fetch=FetchType.LAZY)
    @JoinColumn(name="taskId", referencedColumnName="id", insertable=false, updatable=false, foreignKey=@ForeignKey(value=ConstraintMode.NO_CONSTRAINT, name="none"))
    Set<TaskVariableEntity> variables;
    @JsonView(value={JsonViews.ProcessVariables.class})
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.MERGE})
    @JoinTable(name="task_process_variable", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="process_variable_id")})
    Set<ProcessVariableEntity> processVariables;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient boolean $$_hibernate_useTracker;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public TaskEntity() {
        this.$$_hibernate_write_taskCandidateUsers(new LinkedHashSet());
        this.$$_hibernate_write_taskCandidateGroups(new LinkedHashSet());
        this.$$_hibernate_write_variables(new LinkedHashSet());
        this.$$_hibernate_write_processVariables(new LinkedHashSet());
    }

    public TaskEntity(CloudTaskCreatedEvent taskCreatedEvent) {
        super(taskCreatedEvent.getServiceName(), taskCreatedEvent.getServiceFullName(), taskCreatedEvent.getServiceVersion(), taskCreatedEvent.getAppName(), taskCreatedEvent.getAppVersion());
        this.$$_hibernate_write_taskCandidateUsers(new LinkedHashSet());
        this.$$_hibernate_write_taskCandidateGroups(new LinkedHashSet());
        this.$$_hibernate_write_variables(new LinkedHashSet());
        this.$$_hibernate_write_processVariables(new LinkedHashSet());
        Task task = (Task)taskCreatedEvent.getEntity();
        this.$$_hibernate_write_id(task.getId());
        this.$$_hibernate_write_assignee(task.getAssignee());
        this.$$_hibernate_write_name(task.getName());
        this.$$_hibernate_write_description(task.getDescription());
        this.$$_hibernate_write_createdDate(task.getCreatedDate());
        this.$$_hibernate_write_dueDate(task.getDueDate());
        this.$$_hibernate_write_priority(task.getPriority());
        this.$$_hibernate_write_processDefinitionId(task.getProcessDefinitionId());
        this.$$_hibernate_write_processInstanceId(task.getProcessInstanceId());
        this.$$_hibernate_write_status(task.getStatus());
        this.$$_hibernate_write_lastModified(task.getCreatedDate());
        this.$$_hibernate_write_claimedDate(task.getClaimedDate());
        this.$$_hibernate_write_owner(task.getOwner());
        this.$$_hibernate_write_parentTaskId(task.getParentTaskId());
        this.$$_hibernate_write_formKey(task.getFormKey());
        this.$$_hibernate_write_processDefinitionVersion(taskCreatedEvent.getProcessDefinitionVersion());
        this.$$_hibernate_write_businessKey(taskCreatedEvent.getBusinessKey());
        this.$$_hibernate_write_taskDefinitionKey(task.getTaskDefinitionKey());
    }

    public String getId() {
        return this.$$_hibernate_read_id();
    }

    public String getAssignee() {
        return this.$$_hibernate_read_assignee();
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public String getDescription() {
        return this.$$_hibernate_read_description();
    }

    public Date getCreatedDate() {
        return this.$$_hibernate_read_createdDate();
    }

    public Date getDueDate() {
        return this.$$_hibernate_read_dueDate();
    }

    public int getPriority() {
        return this.$$_hibernate_read_priority();
    }

    public String getProcessDefinitionId() {
        return this.$$_hibernate_read_processDefinitionId();
    }

    public String getProcessDefinitionName() {
        return this.$$_hibernate_read_processDefinitionName();
    }

    public String getProcessInstanceId() {
        return this.$$_hibernate_read_processInstanceId();
    }

    public Integer getProcessDefinitionVersion() {
        return this.$$_hibernate_read_processDefinitionVersion();
    }

    public String getBusinessKey() {
        return this.$$_hibernate_read_businessKey();
    }

    public boolean isStandalone() {
        return this.getProcessInstanceId() == null;
    }

    public Task.TaskStatus getStatus() {
        return this.$$_hibernate_read_status();
    }

    public Date getLastModified() {
        return this.$$_hibernate_read_lastModified();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id);
    }

    public void setAssignee(String assignee) {
        this.$$_hibernate_write_assignee(assignee);
    }

    public void setName(String name) {
        this.$$_hibernate_write_name(name);
    }

    public void setDescription(String description) {
        this.$$_hibernate_write_description(description);
    }

    public void setCreatedDate(Date createdDate) {
        this.$$_hibernate_write_createdDate(createdDate);
    }

    public void setDueDate(Date dueDate) {
        this.$$_hibernate_write_dueDate(dueDate);
    }

    public void setPriority(int priority) {
        this.$$_hibernate_write_priority(priority);
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.$$_hibernate_write_processDefinitionId(processDefinitionId);
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.$$_hibernate_write_processInstanceId(processInstanceId);
    }

    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.$$_hibernate_write_processDefinitionVersion(processDefinitionVersion);
    }

    public void setProcessDefinitionName(String processDefinitionName) {
        this.$$_hibernate_write_processDefinitionName(processDefinitionName);
    }

    public void setBusinessKey(String businessKey) {
        this.$$_hibernate_write_businessKey(businessKey);
    }

    public void setStatus(Task.TaskStatus status) {
        this.$$_hibernate_write_status(status);
    }

    public void setLastModified(Date lastModified) {
        this.$$_hibernate_write_lastModified(lastModified);
    }

    @Transient
    public Date getLastModifiedTo() {
        return this.lastModifiedTo;
    }

    public void setLastModifiedTo(Date lastModifiedTo) {
        this.lastModifiedTo = lastModifiedTo;
    }

    @Transient
    public Date getLastModifiedFrom() {
        return this.lastModifiedFrom;
    }

    public Date getClaimedDate() {
        return this.$$_hibernate_read_claimedDate();
    }

    public void setClaimedDate(Date claimedDate) {
        this.$$_hibernate_write_claimedDate(claimedDate);
    }

    public String getOwner() {
        return this.$$_hibernate_read_owner();
    }

    public void setOwner(String owner) {
        this.$$_hibernate_write_owner(owner);
    }

    public void setLastModifiedFrom(Date lastModifiedFrom) {
        this.lastModifiedFrom = lastModifiedFrom;
    }

    public ProcessInstance getProcessInstance() {
        return this.$$_hibernate_read_processInstance();
    }

    public void setProcessInstance(ProcessInstanceEntity processInstance) {
        this.$$_hibernate_write_processInstance(processInstance);
    }

    public Set<TaskVariableEntity> getVariables() {
        return this.$$_hibernate_read_variables();
    }

    public void setVariables(Set<TaskVariableEntity> variables) {
        this.$$_hibernate_write_variables(variables);
    }

    public Set<TaskCandidateUserEntity> getTaskCandidateUsers() {
        return this.$$_hibernate_read_taskCandidateUsers();
    }

    public void setTaskCandidateUsers(Set<TaskCandidateUserEntity> taskCandidateUsers) {
        this.$$_hibernate_write_taskCandidateUsers(taskCandidateUsers);
    }

    public List<String> getCandidateUsers() {
        return this.$$_hibernate_read_taskCandidateUsers() != null ? this.$$_hibernate_read_taskCandidateUsers().stream().map(TaskCandidateUserEntity::getUserId).collect(Collectors.toList()) : Collections.emptyList();
    }

    public List<String> getCandidateGroups() {
        return this.$$_hibernate_read_taskCandidateGroups() != null ? this.$$_hibernate_read_taskCandidateGroups().stream().map(TaskCandidateGroupEntity::getGroupId).collect(Collectors.toList()) : Collections.emptyList();
    }

    public Set<TaskCandidateGroupEntity> getTaskCandidateGroups() {
        return this.$$_hibernate_read_taskCandidateGroups();
    }

    public void setTaskCandidateGroups(Set<TaskCandidateGroupEntity> taskCandidateGroups) {
        this.$$_hibernate_write_taskCandidateGroups(taskCandidateGroups);
    }

    public String getParentTaskId() {
        return this.$$_hibernate_read_parentTaskId();
    }

    public void setParentTaskId(String parentTaskId) {
        this.$$_hibernate_write_parentTaskId(parentTaskId);
    }

    public String getFormKey() {
        return this.$$_hibernate_read_formKey();
    }

    public void setFormKey(String formKey) {
        this.$$_hibernate_write_formKey(formKey);
    }

    public String getTaskDefinitionKey() {
        return this.$$_hibernate_read_taskDefinitionKey();
    }

    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.$$_hibernate_write_taskDefinitionKey(taskDefinitionKey);
    }

    public Long getDuration() {
        return this.$$_hibernate_read_duration();
    }

    public void setDuration(long duration) {
        this.$$_hibernate_write_duration(duration);
    }

    @Transient
    public Date getCompletedDate() {
        return this.completedDate;
    }

    public void setCompletedDate(Date endDate) {
        this.completedDate = endDate;
    }

    @Transient
    public Date getCreatedTo() {
        return this.createdTo;
    }

    public void setCreatedTo(Date createdTo) {
        this.createdTo = createdTo;
    }

    @Transient
    public Date getCreatedFrom() {
        return this.createdFrom;
    }

    public void setCreatedFrom(Date createdFrom) {
        this.createdFrom = createdFrom;
    }

    @Transient
    public Date getLastClaimedTo() {
        return this.lastClaimedTo;
    }

    public void setLastClaimedTo(Date lastClaimedTo) {
        this.lastClaimedTo = lastClaimedTo;
    }

    @Transient
    public Date getLastClaimedFrom() {
        return this.lastClaimedFrom;
    }

    public void setLastClaimedFrom(Date lastClaimedFrom) {
        this.lastClaimedFrom = lastClaimedFrom;
    }

    @Transient
    public Date getCompletedTo() {
        return this.completedTo;
    }

    public void setCompletedTo(Date completedTo) {
        this.completedTo = completedTo;
    }

    @Transient
    public Date getCompletedFrom() {
        return this.completedFrom;
    }

    public void setCompletedFrom(Date completedFrom) {
        this.completedFrom = completedFrom;
    }

    public String getCompletedBy() {
        return this.$$_hibernate_read_completedBy();
    }

    public void setCompletedBy(String completedBy) {
        this.$$_hibernate_write_completedBy(completedBy);
    }

    public Optional<TaskVariableEntity> getVariable(String variableName) {
        return this.getVariables().stream().filter(v -> v.getName().equals(variableName)).findFirst();
    }

    public boolean isInFinalState() {
        return !Task.TaskStatus.CREATED.equals((Object)this.$$_hibernate_read_status()) && !Task.TaskStatus.ASSIGNED.equals((Object)this.$$_hibernate_read_status()) && !Task.TaskStatus.SUSPENDED.equals((Object)this.$$_hibernate_read_status());
    }

    public List<QueryCloudTask.TaskPermissions> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<QueryCloudTask.TaskPermissions> permissions) {
        this.permissions = permissions;
    }

    public Set<ProcessVariableEntity> getProcessVariables() {
        return this.$$_hibernate_read_processVariables();
    }

    public void setProcessVariables(Set<ProcessVariableEntity> processVariables) {
        this.$$_hibernate_write_processVariables(new LinkedHashSet());
        this.$$_hibernate_read_processVariables().addAll(processVariables);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskEntity other = (TaskEntity)obj;
        return this.$$_hibernate_read_id() != null && Objects.equals(this.$$_hibernate_read_id(), other.$$_hibernate_read_id());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public boolean $$_hibernate_useTracker() {
        return this.$$_hibernate_useTracker;
    }

    public void $$_hibernate_setUseTracker(boolean bl) {
        this.$$_hibernate_useTracker = bl;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        TaskEntity taskEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        int n;
        block12: {
            int n2;
            block13: {
                int n3;
                TaskEntity taskEntity = this;
                TaskEntity taskEntity2 = taskEntity;
                TaskEntity taskEntity3 = taskEntity2;
                TaskEntity taskEntity4 = taskEntity3;
                int n4 = 0;
                if (n4 == 0 && taskEntity3.$$_hibernate_collectionTracker != null) {
                    int n5 = taskEntity3.$$_hibernate_collectionTracker.getSize("taskCandidateUsers");
                    if (taskEntity3.taskCandidateUsers == null && n5 != -1) {
                        n4 = 1;
                    } else if (taskEntity3.taskCandidateUsers != null && (!(taskEntity3.taskCandidateUsers instanceof PersistentCollection) || ((PersistentCollection)taskEntity3.taskCandidateUsers).wasInitialized()) && n5 != taskEntity3.taskCandidateUsers.size()) {
                        n4 = 1;
                    }
                }
                if ((n3 = n4) == 0 && taskEntity2.$$_hibernate_collectionTracker != null) {
                    n4 = taskEntity2.$$_hibernate_collectionTracker.getSize("taskCandidateGroups");
                    if (taskEntity2.taskCandidateGroups == null && n4 != -1) {
                        n3 = 1;
                    } else if (taskEntity2.taskCandidateGroups != null && (!(taskEntity2.taskCandidateGroups instanceof PersistentCollection) || ((PersistentCollection)taskEntity2.taskCandidateGroups).wasInitialized()) && n4 != taskEntity2.taskCandidateGroups.size()) {
                        n3 = 1;
                    }
                }
                if ((n2 = n3) == 0 && taskEntity.$$_hibernate_collectionTracker != null) {
                    n3 = taskEntity.$$_hibernate_collectionTracker.getSize("variables");
                    if (taskEntity.variables == null && n3 != -1) {
                        n2 = 1;
                    } else if (taskEntity.variables != null && (!(taskEntity.variables instanceof PersistentCollection) || ((PersistentCollection)taskEntity.variables).wasInitialized()) && n3 != taskEntity.variables.size()) {
                        n2 = 1;
                    }
                }
                if ((n = n2) != 0 || this.$$_hibernate_collectionTracker == null) break block12;
                n2 = this.$$_hibernate_collectionTracker.getSize("processVariables");
                if (this.processVariables != null || n2 == -1) break block13;
                n = 1;
                break block12;
            }
            if (this.processVariables == null || this.processVariables instanceof PersistentCollection && !((PersistentCollection)this.processVariables).wasInitialized() || n2 == this.processVariables.size()) break block12;
            n = 1;
        }
        return n != 0;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block12: {
            int n;
            block13: {
                TaskEntity taskEntity = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                TaskEntity taskEntity2 = taskEntity;
                DirtyTracker dirtyTracker3 = dirtyTracker2;
                TaskEntity taskEntity3 = taskEntity2;
                DirtyTracker dirtyTracker4 = dirtyTracker3;
                TaskEntity taskEntity4 = taskEntity3;
                DirtyTracker dirtyTracker5 = dirtyTracker4;
                if (taskEntity3.$$_hibernate_collectionTracker != null) {
                    int n2 = taskEntity3.$$_hibernate_collectionTracker.getSize("taskCandidateUsers");
                    if (taskEntity3.taskCandidateUsers == null && n2 != -1) {
                        dirtyTracker4.add("taskCandidateUsers");
                    } else if (taskEntity3.taskCandidateUsers != null && (!(taskEntity3.taskCandidateUsers instanceof PersistentCollection) || ((PersistentCollection)taskEntity3.taskCandidateUsers).wasInitialized()) && n2 != taskEntity3.taskCandidateUsers.size()) {
                        dirtyTracker4.add("taskCandidateUsers");
                    }
                }
                if (taskEntity2.$$_hibernate_collectionTracker != null) {
                    int n3 = taskEntity2.$$_hibernate_collectionTracker.getSize("taskCandidateGroups");
                    if (taskEntity2.taskCandidateGroups == null && n3 != -1) {
                        dirtyTracker3.add("taskCandidateGroups");
                    } else if (taskEntity2.taskCandidateGroups != null && (!(taskEntity2.taskCandidateGroups instanceof PersistentCollection) || ((PersistentCollection)taskEntity2.taskCandidateGroups).wasInitialized()) && n3 != taskEntity2.taskCandidateGroups.size()) {
                        dirtyTracker3.add("taskCandidateGroups");
                    }
                }
                if (taskEntity.$$_hibernate_collectionTracker != null) {
                    int n4 = taskEntity.$$_hibernate_collectionTracker.getSize("variables");
                    if (taskEntity.variables == null && n4 != -1) {
                        dirtyTracker2.add("variables");
                    } else if (taskEntity.variables != null && (!(taskEntity.variables instanceof PersistentCollection) || ((PersistentCollection)taskEntity.variables).wasInitialized()) && n4 != taskEntity.variables.size()) {
                        dirtyTracker2.add("variables");
                    }
                }
                if (this.$$_hibernate_collectionTracker == null) break block12;
                n = this.$$_hibernate_collectionTracker.getSize("processVariables");
                if (this.processVariables != null || n == -1) break block13;
                dirtyTracker.add("processVariables");
                break block12;
            }
            if (this.processVariables == null || this.processVariables instanceof PersistentCollection && !((PersistentCollection)this.processVariables).wasInitialized() || n == this.processVariables.size()) break block12;
            dirtyTracker.add("processVariables");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block12: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            TaskEntity taskEntity = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            TaskEntity taskEntity2 = taskEntity;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor3 = lazyAttributeLoadingInterceptor2;
            TaskEntity taskEntity3 = taskEntity2;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor4 = lazyAttributeLoadingInterceptor3;
            TaskEntity taskEntity4 = taskEntity3;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor5 = lazyAttributeLoadingInterceptor4;
            if (lazyAttributeLoadingInterceptor4 == null || lazyAttributeLoadingInterceptor4.isAttributeLoaded("taskCandidateUsers")) {
                if (taskEntity3.taskCandidateUsers == null || taskEntity3.taskCandidateUsers instanceof PersistentCollection && !((PersistentCollection)taskEntity3.taskCandidateUsers).wasInitialized()) {
                    taskEntity3.$$_hibernate_collectionTracker.add("taskCandidateUsers", -1);
                } else {
                    taskEntity3.$$_hibernate_collectionTracker.add("taskCandidateUsers", taskEntity3.taskCandidateUsers.size());
                }
            }
            if (lazyAttributeLoadingInterceptor3 == null || lazyAttributeLoadingInterceptor3.isAttributeLoaded("taskCandidateGroups")) {
                if (taskEntity2.taskCandidateGroups == null || taskEntity2.taskCandidateGroups instanceof PersistentCollection && !((PersistentCollection)taskEntity2.taskCandidateGroups).wasInitialized()) {
                    taskEntity2.$$_hibernate_collectionTracker.add("taskCandidateGroups", -1);
                } else {
                    taskEntity2.$$_hibernate_collectionTracker.add("taskCandidateGroups", taskEntity2.taskCandidateGroups.size());
                }
            }
            if (lazyAttributeLoadingInterceptor2 == null || lazyAttributeLoadingInterceptor2.isAttributeLoaded("variables")) {
                if (taskEntity.variables == null || taskEntity.variables instanceof PersistentCollection && !((PersistentCollection)taskEntity.variables).wasInitialized()) {
                    taskEntity.$$_hibernate_collectionTracker.add("variables", -1);
                } else {
                    taskEntity.$$_hibernate_collectionTracker.add("variables", taskEntity.variables.size());
                }
            }
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("processVariables")) break block12;
            if (this.processVariables == null || this.processVariables instanceof PersistentCollection && !((PersistentCollection)this.processVariables).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("processVariables", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("processVariables", this.processVariables.size());
            }
        }
    }

    @Override
    public String $$_hibernate_read_serviceName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceName", (Object)this.serviceName);
        }
        return this.serviceName;
    }

    @Override
    public void $$_hibernate_write_serviceName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceName", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_serviceName())) {
            this.$$_hibernate_trackChange("serviceName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceName", (Object)this.serviceName, (Object)string);
            return;
        }
        this.serviceName = string;
    }

    @Override
    public String $$_hibernate_read_serviceFullName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceFullName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceFullName", (Object)this.serviceFullName);
        }
        return this.serviceFullName;
    }

    @Override
    public void $$_hibernate_write_serviceFullName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceFullName", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_serviceFullName())) {
            this.$$_hibernate_trackChange("serviceFullName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceFullName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceFullName", (Object)this.serviceFullName, (Object)string);
            return;
        }
        this.serviceFullName = string;
    }

    @Override
    public String $$_hibernate_read_serviceVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceVersion = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceVersion", (Object)this.serviceVersion);
        }
        return this.serviceVersion;
    }

    @Override
    public void $$_hibernate_write_serviceVersion(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceVersion", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_serviceVersion())) {
            this.$$_hibernate_trackChange("serviceVersion");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceVersion = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceVersion", (Object)this.serviceVersion, (Object)string);
            return;
        }
        this.serviceVersion = string;
    }

    @Override
    public String $$_hibernate_read_appName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.appName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "appName", (Object)this.appName);
        }
        return this.appName;
    }

    @Override
    public void $$_hibernate_write_appName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"appName", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_appName())) {
            this.$$_hibernate_trackChange("appName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.appName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "appName", (Object)this.appName, (Object)string);
            return;
        }
        this.appName = string;
    }

    @Override
    public String $$_hibernate_read_appVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.appVersion = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "appVersion", (Object)this.appVersion);
        }
        return this.appVersion;
    }

    @Override
    public void $$_hibernate_write_appVersion(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"appVersion", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_appVersion())) {
            this.$$_hibernate_trackChange("appVersion");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.appVersion = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "appVersion", (Object)this.appVersion, (Object)string);
            return;
        }
        this.appVersion = string;
    }

    @Override
    public String $$_hibernate_read_serviceType() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceType = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceType", (Object)this.serviceType);
        }
        return this.serviceType;
    }

    @Override
    public void $$_hibernate_write_serviceType(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceType", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_serviceType())) {
            this.$$_hibernate_trackChange("serviceType");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceType = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceType", (Object)this.serviceType, (Object)string);
            return;
        }
        this.serviceType = string;
    }

    public String $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)string);
            return;
        }
        this.id = string;
    }

    public String $$_hibernate_read_assignee() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.assignee = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "assignee", (Object)this.assignee);
        }
        return this.assignee;
    }

    public void $$_hibernate_write_assignee(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"assignee", (Object)string, (Object)this.assignee)) {
            this.$$_hibernate_trackChange("assignee");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.assignee = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "assignee", (Object)this.assignee, (Object)string);
            return;
        }
        this.assignee = string;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"name", (Object)string, (Object)this.name)) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public String $$_hibernate_read_description() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "description", (Object)this.description);
        }
        return this.description;
    }

    public void $$_hibernate_write_description(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"description", (Object)string, (Object)this.description)) {
            this.$$_hibernate_trackChange("description");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "description", (Object)this.description, (Object)string);
            return;
        }
        this.description = string;
    }

    public Date $$_hibernate_read_createdDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.createdDate = (Date)this.$$_hibernate_getInterceptor().readObject((Object)this, "createdDate", (Object)this.createdDate);
        }
        return this.createdDate;
    }

    public void $$_hibernate_write_createdDate(Date date) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"createdDate", (Object)date, (Object)this.createdDate)) {
            this.$$_hibernate_trackChange("createdDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.createdDate = (Date)this.$$_hibernate_getInterceptor().writeObject((Object)this, "createdDate", (Object)this.createdDate, (Object)date);
            return;
        }
        this.createdDate = date;
    }

    public Date $$_hibernate_read_dueDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.dueDate = (Date)this.$$_hibernate_getInterceptor().readObject((Object)this, "dueDate", (Object)this.dueDate);
        }
        return this.dueDate;
    }

    public void $$_hibernate_write_dueDate(Date date) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"dueDate", (Object)date, (Object)this.dueDate)) {
            this.$$_hibernate_trackChange("dueDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.dueDate = (Date)this.$$_hibernate_getInterceptor().writeObject((Object)this, "dueDate", (Object)this.dueDate, (Object)date);
            return;
        }
        this.dueDate = date;
    }

    public Date $$_hibernate_read_claimedDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.claimedDate = (Date)this.$$_hibernate_getInterceptor().readObject((Object)this, "claimedDate", (Object)this.claimedDate);
        }
        return this.claimedDate;
    }

    public void $$_hibernate_write_claimedDate(Date date) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"claimedDate", (Object)date, (Object)this.claimedDate)) {
            this.$$_hibernate_trackChange("claimedDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.claimedDate = (Date)this.$$_hibernate_getInterceptor().writeObject((Object)this, "claimedDate", (Object)this.claimedDate, (Object)date);
            return;
        }
        this.claimedDate = date;
    }

    public int $$_hibernate_read_priority() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.priority = this.$$_hibernate_getInterceptor().readInt((Object)this, "priority", this.priority);
        }
        return this.priority;
    }

    public void $$_hibernate_write_priority(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"priority", (int)n, (int)this.priority)) {
            this.$$_hibernate_trackChange("priority");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.priority = this.$$_hibernate_getInterceptor().writeInt((Object)this, "priority", this.priority, n);
            return;
        }
        this.priority = n;
    }

    public String $$_hibernate_read_processDefinitionId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "processDefinitionId", (Object)this.processDefinitionId);
        }
        return this.processDefinitionId;
    }

    public void $$_hibernate_write_processDefinitionId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"processDefinitionId", (Object)string, (Object)this.processDefinitionId)) {
            this.$$_hibernate_trackChange("processDefinitionId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processDefinitionId", (Object)this.processDefinitionId, (Object)string);
            return;
        }
        this.processDefinitionId = string;
    }

    public String $$_hibernate_read_processInstanceId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processInstanceId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "processInstanceId", (Object)this.processInstanceId);
        }
        return this.processInstanceId;
    }

    public void $$_hibernate_write_processInstanceId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"processInstanceId", (Object)string, (Object)this.processInstanceId)) {
            this.$$_hibernate_trackChange("processInstanceId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processInstanceId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processInstanceId", (Object)this.processInstanceId, (Object)string);
            return;
        }
        this.processInstanceId = string;
    }

    public Integer $$_hibernate_read_processDefinitionVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionVersion = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "processDefinitionVersion", (Object)this.processDefinitionVersion);
        }
        return this.processDefinitionVersion;
    }

    public void $$_hibernate_write_processDefinitionVersion(Integer n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"processDefinitionVersion", (Object)n, (Object)this.processDefinitionVersion)) {
            this.$$_hibernate_trackChange("processDefinitionVersion");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionVersion = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processDefinitionVersion", (Object)this.processDefinitionVersion, (Object)n);
            return;
        }
        this.processDefinitionVersion = n;
    }

    public String $$_hibernate_read_processDefinitionName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "processDefinitionName", (Object)this.processDefinitionName);
        }
        return this.processDefinitionName;
    }

    public void $$_hibernate_write_processDefinitionName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"processDefinitionName", (Object)string, (Object)this.processDefinitionName)) {
            this.$$_hibernate_trackChange("processDefinitionName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processDefinitionName", (Object)this.processDefinitionName, (Object)string);
            return;
        }
        this.processDefinitionName = string;
    }

    public String $$_hibernate_read_businessKey() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.businessKey = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "businessKey", (Object)this.businessKey);
        }
        return this.businessKey;
    }

    public void $$_hibernate_write_businessKey(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"businessKey", (Object)string, (Object)this.businessKey)) {
            this.$$_hibernate_trackChange("businessKey");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.businessKey = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "businessKey", (Object)this.businessKey, (Object)string);
            return;
        }
        this.businessKey = string;
    }

    public String $$_hibernate_read_taskDefinitionKey() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.taskDefinitionKey = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "taskDefinitionKey", (Object)this.taskDefinitionKey);
        }
        return this.taskDefinitionKey;
    }

    public void $$_hibernate_write_taskDefinitionKey(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"taskDefinitionKey", (Object)string, (Object)this.taskDefinitionKey)) {
            this.$$_hibernate_trackChange("taskDefinitionKey");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.taskDefinitionKey = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "taskDefinitionKey", (Object)this.taskDefinitionKey, (Object)string);
            return;
        }
        this.taskDefinitionKey = string;
    }

    public String $$_hibernate_read_completedBy() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.completedBy = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "completedBy", (Object)this.completedBy);
        }
        return this.completedBy;
    }

    public void $$_hibernate_write_completedBy(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"completedBy", (Object)string, (Object)this.completedBy)) {
            this.$$_hibernate_trackChange("completedBy");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.completedBy = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "completedBy", (Object)this.completedBy, (Object)string);
            return;
        }
        this.completedBy = string;
    }

    public Task.TaskStatus $$_hibernate_read_status() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.status = (Task.TaskStatus)this.$$_hibernate_getInterceptor().readObject((Object)this, "status", (Object)this.status);
        }
        return this.status;
    }

    public void $$_hibernate_write_status(Task.TaskStatus taskStatus) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"status", (Object)taskStatus, (Object)this.status)) {
            this.$$_hibernate_trackChange("status");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.status = (Task.TaskStatus)this.$$_hibernate_getInterceptor().writeObject((Object)this, "status", (Object)this.status, (Object)taskStatus);
            return;
        }
        this.status = taskStatus;
    }

    public String $$_hibernate_read_owner() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "owner", (Object)this.owner);
        }
        return this.owner;
    }

    public void $$_hibernate_write_owner(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"owner", (Object)string, (Object)this.owner)) {
            this.$$_hibernate_trackChange("owner");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.owner = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "owner", (Object)this.owner, (Object)string);
            return;
        }
        this.owner = string;
    }

    public String $$_hibernate_read_parentTaskId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.parentTaskId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "parentTaskId", (Object)this.parentTaskId);
        }
        return this.parentTaskId;
    }

    public void $$_hibernate_write_parentTaskId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"parentTaskId", (Object)string, (Object)this.parentTaskId)) {
            this.$$_hibernate_trackChange("parentTaskId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.parentTaskId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "parentTaskId", (Object)this.parentTaskId, (Object)string);
            return;
        }
        this.parentTaskId = string;
    }

    public String $$_hibernate_read_formKey() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.formKey = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "formKey", (Object)this.formKey);
        }
        return this.formKey;
    }

    public void $$_hibernate_write_formKey(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"formKey", (Object)string, (Object)this.formKey)) {
            this.$$_hibernate_trackChange("formKey");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.formKey = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "formKey", (Object)this.formKey, (Object)string);
            return;
        }
        this.formKey = string;
    }

    public Long $$_hibernate_read_duration() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.duration = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "duration", (Object)this.duration);
        }
        return this.duration;
    }

    public void $$_hibernate_write_duration(Long l) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"duration", (Object)l, (Object)this.duration)) {
            this.$$_hibernate_trackChange("duration");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.duration = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "duration", (Object)this.duration, (Object)l);
            return;
        }
        this.duration = l;
    }

    public Date $$_hibernate_read_lastModified() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastModified = (Date)this.$$_hibernate_getInterceptor().readObject((Object)this, "lastModified", (Object)this.lastModified);
        }
        return this.lastModified;
    }

    public void $$_hibernate_write_lastModified(Date date) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"lastModified", (Object)date, (Object)this.lastModified)) {
            this.$$_hibernate_trackChange("lastModified");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastModified = (Date)this.$$_hibernate_getInterceptor().writeObject((Object)this, "lastModified", (Object)this.lastModified, (Object)date);
            return;
        }
        this.lastModified = date;
    }

    public ProcessInstanceEntity $$_hibernate_read_processInstance() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processInstance = (ProcessInstanceEntity)this.$$_hibernate_getInterceptor().readObject((Object)this, "processInstance", (Object)this.processInstance);
        }
        return this.processInstance;
    }

    public void $$_hibernate_write_processInstance(ProcessInstanceEntity processInstanceEntity) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"processInstance", (Object)processInstanceEntity, (Object)this.processInstance)) {
            this.$$_hibernate_trackChange("processInstance");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processInstance = (ProcessInstanceEntity)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processInstance", (Object)this.processInstance, (Object)processInstanceEntity);
            return;
        }
        this.processInstance = processInstanceEntity;
    }

    public Set $$_hibernate_read_taskCandidateUsers() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.taskCandidateUsers = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "taskCandidateUsers", this.taskCandidateUsers);
        }
        return this.taskCandidateUsers;
    }

    public void $$_hibernate_write_taskCandidateUsers(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.taskCandidateUsers = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "taskCandidateUsers", this.taskCandidateUsers, (Object)set);
            return;
        }
        this.taskCandidateUsers = set;
    }

    public Set $$_hibernate_read_taskCandidateGroups() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.taskCandidateGroups = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "taskCandidateGroups", this.taskCandidateGroups);
        }
        return this.taskCandidateGroups;
    }

    public void $$_hibernate_write_taskCandidateGroups(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.taskCandidateGroups = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "taskCandidateGroups", this.taskCandidateGroups, (Object)set);
            return;
        }
        this.taskCandidateGroups = set;
    }

    public Set $$_hibernate_read_variables() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.variables = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "variables", this.variables);
        }
        return this.variables;
    }

    public void $$_hibernate_write_variables(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.variables = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "variables", this.variables, (Object)set);
            return;
        }
        this.variables = set;
    }

    public Set $$_hibernate_read_processVariables() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processVariables = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "processVariables", this.processVariables);
        }
        return this.processVariables;
    }

    public void $$_hibernate_write_processVariables(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processVariables = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processVariables", this.processVariables, (Object)set);
            return;
        }
        this.processVariables = set;
    }
}

