/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.dialect;

import java.io.Serializable;
import org.activiti.cloud.dialect.RelationalFormType;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.StringJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.VarcharJdbcType;
import org.hibernate.type.internal.NamedBasicTypeImpl;

public class DoubleQuotedStringType
extends NamedBasicTypeImpl<String> {
    private final RelationalFormType relationalFormType;

    public DoubleQuotedStringType() {
        this(RelationalFormType.EXACT_COMPARISON);
    }

    public DoubleQuotedStringType(RelationalFormType relationalFormType) {
        super((JavaType)StringJavaType.INSTANCE, (JdbcType)VarcharJdbcType.INSTANCE, "doublequotedstring");
        this.relationalFormType = relationalFormType;
    }

    public BasicValueConverter<String, String> getValueConverter() {
        return new BasicValueConverter<String, String>(){

            public String toDomainValue(String relationalForm) {
                return relationalForm.replace(".*", "").replace("(?i)", "");
            }

            public String toRelationalValue(String domainForm) {
                return switch (DoubleQuotedStringType.this.relationalFormType) {
                    default -> throw new MatchException(null, null);
                    case RelationalFormType.EXACT_COMPARISON -> domainForm;
                    case RelationalFormType.LIKE_CASE_SENSITIVE -> ".*" + domainForm + ".*";
                    case RelationalFormType.LIKE_CASE_INSENSITIVE -> "(?i).*" + domainForm + ".*";
                };
            }

            public JavaType<String> getDomainJavaType() {
                return StringJavaType.INSTANCE;
            }

            public JavaType<String> getRelationalJavaType() {
                return StringJavaType.INSTANCE;
            }
        };
    }

    public JdbcLiteralFormatter<String> getJdbcLiteralFormatter() {
        return (JdbcLiteralFormatter & Serializable)(appender, value, dialect, wrapperOptions) -> {
            appender.append((CharSequence)"\"");
            appender.append((CharSequence)value);
            appender.append((CharSequence)"\"");
        };
    }
}

