/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.fasterxml.jackson.annotation.JsonView;
import com.querydsl.core.types.Predicate;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.api.runtime.shared.security.SecurityManager;
import org.activiti.cloud.api.task.model.QueryCloudTask;
import org.activiti.cloud.services.query.app.repository.EntityFinder;
import org.activiti.cloud.services.query.app.repository.TaskRepository;
import org.activiti.cloud.services.query.model.JsonViews;
import org.activiti.cloud.services.query.model.QTaskEntity;
import org.activiti.cloud.services.query.model.TaskCandidateGroupEntity;
import org.activiti.cloud.services.query.model.TaskCandidateUserEntity;
import org.activiti.cloud.services.query.model.TaskEntity;
import org.activiti.cloud.services.query.rest.TaskControllerHelper;
import org.activiti.cloud.services.query.rest.TaskPermissionsHelper;
import org.activiti.cloud.services.query.rest.VariableSearch;
import org.activiti.cloud.services.query.rest.advice.TaskControllerAdvice;
import org.activiti.cloud.services.query.rest.assembler.TaskRepresentationModelAssembler;
import org.activiti.cloud.services.query.rest.payload.TaskSearchRequest;
import org.activiti.cloud.services.query.rest.predicate.RootTasksFilter;
import org.activiti.cloud.services.query.rest.predicate.StandAloneTaskFilter;
import org.activiti.cloud.services.security.TaskLookupRestrictionService;
import org.activiti.core.common.spring.security.policies.ActivitiForbiddenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.repository.CrudRepository;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/tasks"}, produces={"application/hal+json", "application/json"})
public class TaskController
extends TaskControllerAdvice {
    private final TaskRepository taskRepository;
    private TaskRepresentationModelAssembler taskRepresentationModelAssembler;
    private EntityFinder entityFinder;
    private TaskLookupRestrictionService taskLookupRestrictionService;
    private SecurityManager securityManager;
    private TaskControllerHelper taskControllerHelper;
    private TaskPermissionsHelper taskPermissionsHelper;
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskController.class);

    public TaskController(TaskRepository taskRepository, TaskRepresentationModelAssembler taskRepresentationModelAssembler, EntityFinder entityFinder, TaskLookupRestrictionService taskLookupRestrictionService, SecurityManager securityManager, TaskControllerHelper taskControllerHelper, TaskPermissionsHelper taskPermissionsHelper) {
        this.taskRepository = taskRepository;
        this.taskRepresentationModelAssembler = taskRepresentationModelAssembler;
        this.entityFinder = entityFinder;
        this.taskLookupRestrictionService = taskLookupRestrictionService;
        this.securityManager = securityManager;
        this.taskControllerHelper = taskControllerHelper;
        this.taskPermissionsHelper = taskPermissionsHelper;
    }

    @Operation(summary="Find tasks", hidden=true)
    @JsonView(value={JsonViews.General.class})
    @RequestMapping(method={RequestMethod.GET}, params={"!variableKeys"})
    public PagedModel<EntityModel<QueryCloudTask>> findAllTasks(@Parameter(description="Filter tasks without parent task.") @RequestParam(name="rootTasksOnly", defaultValue="false") Boolean rootTasksOnly, @Parameter(description="Filter tasks without parent process.") @RequestParam(name="standalone", defaultValue="false") Boolean standalone, @Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=TaskEntity.class) Predicate predicate, VariableSearch variableSearch, Pageable pageable) {
        return this.taskControllerHelper.findAll(predicate, variableSearch, pageable, Arrays.asList(new RootTasksFilter(rootTasksOnly), new StandAloneTaskFilter(standalone), this.taskLookupRestrictionService));
    }

    @Operation(summary="Search tasks")
    @JsonView(value={JsonViews.ProcessVariables.class})
    @PostMapping(value={"/search"})
    public PagedModel<EntityModel<QueryCloudTask>> searchTasks(@RequestBody TaskSearchRequest taskSearchRequest, Pageable pageable) {
        return this.taskControllerHelper.searchTasksRestricted(taskSearchRequest, pageable);
    }

    @Operation(summary="Find tasks")
    @JsonView(value={JsonViews.ProcessVariables.class})
    @RequestMapping(method={RequestMethod.GET}, params={"variableKeys"})
    public PagedModel<EntityModel<QueryCloudTask>> findAllWithProcessVariables(@Parameter(description="Filter tasks without parent task.") @RequestParam(name="rootTasksOnly", defaultValue="false") Boolean rootTasksOnly, @Parameter(description="Filter tasks without parent process.") @RequestParam(name="standalone", defaultValue="false") Boolean standalone, @QuerydslPredicate(root=TaskEntity.class) Predicate predicate, @Parameter(description="Used to retrieve process variables. It is constructed from process definition key and variable name, e.g.: {processDefinitionKey}/{variableName}.", example="Process_90W_3nLpw/initializedVar") @RequestParam(value="variableKeys", required=false, defaultValue="") List<String> processVariableKeys, VariableSearch variableSearch, Pageable pageable) {
        return this.taskControllerHelper.findAllWithProcessVariables(predicate, variableSearch, pageable, Arrays.asList(new RootTasksFilter(rootTasksOnly), new StandAloneTaskFilter(standalone), this.taskLookupRestrictionService), processVariableKeys);
    }

    @JsonView(value={JsonViews.General.class})
    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.GET})
    public EntityModel<QueryCloudTask> findByIdTask(@PathVariable String taskId) {
        boolean canUserViewTask;
        TaskEntity taskEntity = (TaskEntity)this.entityFinder.findById((CrudRepository)this.taskRepository, (Object)taskId, "Unable to find taskEntity for the given id:'" + taskId + "'");
        this.taskPermissionsHelper.setCurrentUserTaskPermissions(taskEntity);
        boolean bl = canUserViewTask = taskEntity.getPermissions() != null && taskEntity.getPermissions().contains(QueryCloudTask.TaskPermissions.VIEW);
        if (!canUserViewTask) {
            LOGGER.debug("User " + this.securityManager.getAuthenticatedUserId() + " not permitted to access taskEntity " + taskId);
            throw new ActivitiForbiddenException("Operation not permitted for " + taskId);
        }
        return this.taskRepresentationModelAssembler.toModel(taskEntity);
    }

    @RequestMapping(value={"/{taskId}/candidate-users"}, method={RequestMethod.GET})
    public List<String> getTaskCandidateUsers(@PathVariable String taskId) {
        TaskEntity taskEntity = (TaskEntity)this.entityFinder.findById((CrudRepository)this.taskRepository, (Object)taskId, "Unable to find taskEntity for the given id:'" + taskId + "'");
        boolean canUserViewTask = this.taskControllerHelper.canUserViewTask((Predicate)QTaskEntity.taskEntity.id.eq((Object)taskId));
        if (!canUserViewTask) {
            LOGGER.debug("User " + this.securityManager.getAuthenticatedUserId() + " not permitted to access taskEntity " + taskId);
            throw new ActivitiForbiddenException("Operation not permitted for " + taskId);
        }
        return taskEntity.getTaskCandidateUsers() != null ? taskEntity.getTaskCandidateUsers().stream().map(TaskCandidateUserEntity::getUserId).collect(Collectors.toList()) : null;
    }

    @RequestMapping(value={"/{taskId}/candidate-groups"}, method={RequestMethod.GET})
    public List<String> getTaskCandidateGroups(@PathVariable String taskId) {
        TaskEntity taskEntity = (TaskEntity)this.entityFinder.findById((CrudRepository)this.taskRepository, (Object)taskId, "Unable to find taskEntity for the given id:'" + taskId + "'");
        boolean canUserViewTask = this.taskControllerHelper.canUserViewTask((Predicate)QTaskEntity.taskEntity.id.eq((Object)taskId));
        if (!canUserViewTask) {
            LOGGER.debug("User " + this.securityManager.getAuthenticatedUserId() + " not permitted to access taskEntity " + taskId);
            throw new ActivitiForbiddenException("Operation not permitted for " + taskId);
        }
        return taskEntity.getTaskCandidateGroups() != null ? taskEntity.getTaskCandidateGroups().stream().map(TaskCandidateGroupEntity::getGroupId).collect(Collectors.toList()) : null;
    }

    @Operation(summary="Count tasks")
    @JsonView(value={JsonViews.ProcessVariables.class})
    @PostMapping(value={"/count"})
    public Long countTasks(@RequestBody TaskSearchRequest taskSearchRequest) {
        return this.taskControllerHelper.countTasksRestricted(taskSearchRequest);
    }
}

