/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.rest;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import io.swagger.v3.oas.annotations.Parameter;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.process.model.CloudServiceTask;
import org.activiti.cloud.services.query.app.repository.ServiceTaskRepository;
import org.activiti.cloud.services.query.model.QServiceTaskEntity;
import org.activiti.cloud.services.query.model.ServiceTaskEntity;
import org.activiti.cloud.services.query.rest.assembler.ServiceTaskRepresentationModelAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/v1/process-instances/{processInstanceId}"}, produces={"application/hal+json", "application/json"})
public class ProcessInstanceServiceTasksAdminController {
    private final ServiceTaskRepresentationModelAssembler taskRepresentationModelAssembler;
    private final AlfrescoPagedModelAssembler<ServiceTaskEntity> pagedCollectionModelAssembler;
    private final ServiceTaskRepository taskRepository;

    @Autowired
    public ProcessInstanceServiceTasksAdminController(ServiceTaskRepository taskRepository, ServiceTaskRepresentationModelAssembler taskRepresentationModelAssembler, AlfrescoPagedModelAssembler<ServiceTaskEntity> pagedCollectionModelAssembler) {
        this.taskRepository = taskRepository;
        this.taskRepresentationModelAssembler = taskRepresentationModelAssembler;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
    }

    @RequestMapping(value={"/service-tasks"}, method={RequestMethod.GET})
    public PagedModel<EntityModel<CloudServiceTask>> getServiceTasks(@PathVariable String processInstanceId, @Parameter(description="Predicate binding to core entity parameter values.", example="{\"name\": \"Real name\"}") @QuerydslPredicate(root=ServiceTaskEntity.class) Predicate predicate, Pageable pageable) {
        BooleanExpression filter = QServiceTaskEntity.serviceTaskEntity.processInstanceId.eq((Object)processInstanceId).and(predicate);
        Page page = this.taskRepository.findAll((Predicate)filter, pageable);
        return this.pagedCollectionModelAssembler.toModel(pageable, page, (RepresentationModelAssembler)this.taskRepresentationModelAssembler);
    }
}

