/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.controllers;

import org.activiti.api.task.model.payloads.CandidateGroupsPayload;
import org.activiti.api.task.runtime.TaskRuntime;
import org.activiti.cloud.api.process.model.impl.CandidateGroup;
import org.activiti.cloud.services.rest.api.CandidateGroupController;
import org.activiti.cloud.services.rest.assemblers.CollectionModelAssembler;
import org.activiti.cloud.services.rest.assemblers.GroupCandidatesRepresentationModelAssembler;
import org.activiti.cloud.services.rest.assemblers.ToCandidateGroupConverter;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CandidateGroupControllerImpl
implements CandidateGroupController {
    private final TaskRuntime taskRuntime;
    private final CollectionModelAssembler resourcesAssembler;
    private final GroupCandidatesRepresentationModelAssembler groupCandidatesRepresentationModelAssembler;
    private final ToCandidateGroupConverter toCandidateGroupConverter;

    public CandidateGroupControllerImpl(TaskRuntime taskRuntime, CollectionModelAssembler resourcesAssembler, GroupCandidatesRepresentationModelAssembler groupCandidatesRepresentationModelAssembler, ToCandidateGroupConverter toCandidateGroupConverter) {
        this.taskRuntime = taskRuntime;
        this.resourcesAssembler = resourcesAssembler;
        this.groupCandidatesRepresentationModelAssembler = groupCandidatesRepresentationModelAssembler;
        this.toCandidateGroupConverter = toCandidateGroupConverter;
    }

    public void addCandidateGroups(@PathVariable String taskId, @RequestBody CandidateGroupsPayload candidateGroupsPayload) {
        if (candidateGroupsPayload != null) {
            candidateGroupsPayload.setTaskId(taskId);
        }
        this.taskRuntime.addCandidateGroups(candidateGroupsPayload);
    }

    public void deleteCandidateGroups(@PathVariable String taskId, @RequestBody CandidateGroupsPayload candidateGroupsPayload) {
        if (candidateGroupsPayload != null) {
            candidateGroupsPayload.setTaskId(taskId);
        }
        this.taskRuntime.deleteCandidateGroups(candidateGroupsPayload);
    }

    public CollectionModel<EntityModel<CandidateGroup>> getGroupCandidates(@PathVariable String taskId) {
        this.groupCandidatesRepresentationModelAssembler.setTaskId(taskId);
        return this.resourcesAssembler.toCollectionModel(this.toCandidateGroupConverter.from(this.taskRuntime.groupCandidates(taskId)), this.groupCandidatesRepresentationModelAssembler, WebMvcLinkBuilder.linkTo(((CandidateGroupControllerImpl)WebMvcLinkBuilder.methodOn(this.getClass(), (Object[])new Object[0])).getGroupCandidates(this.groupCandidatesRepresentationModelAssembler.getTaskId())).withSelfRel());
    }
}

