/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.rest.controllers;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.activiti.api.process.model.ProcessDefinition;
import org.activiti.api.process.runtime.ProcessRuntime;
import org.activiti.api.runtime.shared.query.Page;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.cloud.alfresco.data.domain.AlfrescoPagedModelAssembler;
import org.activiti.cloud.api.process.model.CloudProcessDefinition;
import org.activiti.cloud.api.process.model.ExtendedCloudProcessDefinition;
import org.activiti.cloud.services.core.ProcessDefinitionService;
import org.activiti.cloud.services.core.ProcessDefinitionValuesService;
import org.activiti.cloud.services.core.ProcessDiagramGeneratorWrapper;
import org.activiti.cloud.services.core.pageable.SpringPageConverter;
import org.activiti.cloud.services.rest.api.ProcessDefinitionController;
import org.activiti.cloud.services.rest.assemblers.ExtendedCloudProcessDefinitionRepresentationModelAssembler;
import org.activiti.cloud.services.rest.assemblers.ProcessDefinitionRepresentationModelAssembler;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.util.IoUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(produces={"application/hal+json", "application/json"})
public class ProcessDefinitionControllerImpl
implements ProcessDefinitionController {
    private final RepositoryService repositoryService;
    private final ProcessDiagramGeneratorWrapper processDiagramGenerator;
    private final ProcessDefinitionRepresentationModelAssembler representationModelAssembler;
    private final ExtendedCloudProcessDefinitionRepresentationModelAssembler extendedCloudProcessDefinitionRepresentationModelAssembler;
    private final ProcessRuntime processRuntime;
    private final AlfrescoPagedModelAssembler<ProcessDefinition> pagedCollectionModelAssembler;
    private final SpringPageConverter pageConverter;
    private final ProcessDefinitionService processDefinitionService;
    private final ProcessDefinitionValuesService processDefinitionValuesService;

    @Autowired
    public ProcessDefinitionControllerImpl(RepositoryService repositoryService, ProcessDiagramGeneratorWrapper processDiagramGenerator, ProcessDefinitionRepresentationModelAssembler representationModelAssembler, ExtendedCloudProcessDefinitionRepresentationModelAssembler extendedCloudProcessDefinitionRepresentationModelAssembler, ProcessRuntime processRuntime, AlfrescoPagedModelAssembler<ProcessDefinition> pagedCollectionModelAssembler, SpringPageConverter pageConverter, ProcessDefinitionService processDefinitionService, ProcessDefinitionValuesService processDefinitionValuesService) {
        this.repositoryService = repositoryService;
        this.processDiagramGenerator = processDiagramGenerator;
        this.representationModelAssembler = representationModelAssembler;
        this.extendedCloudProcessDefinitionRepresentationModelAssembler = extendedCloudProcessDefinitionRepresentationModelAssembler;
        this.processRuntime = processRuntime;
        this.pagedCollectionModelAssembler = pagedCollectionModelAssembler;
        this.pageConverter = pageConverter;
        this.processDefinitionService = processDefinitionService;
        this.processDefinitionValuesService = processDefinitionValuesService;
    }

    public PagedModel<EntityModel<ExtendedCloudProcessDefinition>> getProcessDefinitions(@RequestParam(required=false, defaultValue="") List<String> include, Pageable pageable) {
        Page page = this.processDefinitionService.getProcessDefinitions(this.pageConverter.toAPIPageable(pageable), include);
        return this.pagedCollectionModelAssembler.toModel(pageable, this.pageConverter.toSpringPage(pageable, page), (RepresentationModelAssembler)this.extendedCloudProcessDefinitionRepresentationModelAssembler);
    }

    public EntityModel<CloudProcessDefinition> getProcessDefinition(@PathVariable String id) {
        return this.representationModelAssembler.toModel(this.processRuntime.processDefinition(id));
    }

    public String getProcessModel(@PathVariable String id) {
        String string;
        block8: {
            this.checkUserCanReadProcessDefinition(id);
            InputStream resourceStream = this.repositoryService.getProcessModel(id);
            try {
                string = new String(IoUtil.readInputStream((InputStream)resourceStream, null), StandardCharsets.UTF_8);
                if (resourceStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceStream != null) {
                        try {
                            resourceStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ActivitiException("Error occured while getting process model '" + id + "' : " + e.getMessage(), (Throwable)e);
                }
            }
            resourceStream.close();
        }
        return string;
    }

    private void checkUserCanReadProcessDefinition(@PathVariable String id) {
        this.processRuntime.processDefinition(id);
    }

    public String getBpmnModel(@PathVariable String id) {
        this.checkUserCanReadProcessDefinition(id);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(id);
        ObjectNode json = new BpmnJsonConverter().convertToJson(bpmnModel);
        return json.toString();
    }

    public String getProcessDiagram(@PathVariable String id) {
        this.checkUserCanReadProcessDefinition(id);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(id);
        return new String(this.processDiagramGenerator.generateDiagram(bpmnModel), StandardCharsets.UTF_8);
    }

    public Map<String, Object> getProcessModelStaticValuesMappingForStartEvent(String id) {
        this.checkUserCanReadProcessDefinition(id);
        return this.processDefinitionValuesService.getProcessModelStaticValuesMappingForStartEvent(id);
    }

    public Map<String, Object> getProcessModelConstantValuesForStartEvent(String id) {
        this.checkUserCanReadProcessDefinition(id);
        return this.processDefinitionValuesService.getProcessModelConstantValuesForStartEvent(id);
    }
}

