/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.subscriptions.behavior;

import org.activiti.api.process.model.payloads.SignalPayload;
import org.activiti.bpmn.model.Signal;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.bpmn.behavior.IntermediateThrowSignalEventActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.springframework.context.ApplicationEventPublisher;

public class BroadcastSignalEventActivityBehavior
extends IntermediateThrowSignalEventActivityBehavior {
    public static final String DEFAULT_THROW_SIGNAL_EVENT_BEAN_NAME = "defaultThrowSignalEventBehavior";
    private static final long serialVersionUID = 1L;
    private final ApplicationEventPublisher eventPublisher;

    public BroadcastSignalEventActivityBehavior(ApplicationEventPublisher eventPublisher, SignalEventDefinition signalEventDefinition, Signal signal) {
        super(signalEventDefinition, signal);
        this.eventPublisher = eventPublisher;
    }

    public void execute(DelegateExecution execution) {
        String eventSubscriptionName;
        if (this.processInstanceScope) {
            super.execute(execution);
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        if (this.signalEventName != null) {
            eventSubscriptionName = this.signalEventName;
        } else {
            Expression expressionObject = commandContext.getProcessEngineConfiguration().getExpressionManager().createExpression(this.signalExpression);
            eventSubscriptionName = expressionObject.getValue((VariableScope)execution).toString();
        }
        SignalPayload signalPayload = new SignalPayload(eventSubscriptionName, execution.getVariables());
        this.eventPublisher.publishEvent((Object)signalPayload);
        Context.getAgenda().planTakeOutgoingSequenceFlowsOperation((ExecutionEntity)execution, true);
    }
}

