/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.swagger.springdoc;

import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.SecurityScheme;
import org.activiti.cloud.common.swagger.springdoc.SwaggerDocUtils;
import org.activiti.cloud.common.swagger.springdoc.modelconverter.CollectionModelConverter;
import org.activiti.cloud.common.swagger.springdoc.modelconverter.EntityModelConverter;
import org.activiti.cloud.common.swagger.springdoc.modelconverter.IgnoredTypesModelConverter;
import org.activiti.cloud.common.swagger.springdoc.modelconverter.PageableMixin;
import org.activiti.cloud.common.swagger.springdoc.modelconverter.PagedModelConverter;
import org.springframework.boot.info.BuildProperties;
import org.springframework.data.domain.Pageable;

public class BaseOpenApiBuilder {
    public static final String SERVICE_URL_PREFIX = "x-service-url-prefix";
    private final BuildProperties buildProperties;
    private final OAuthFlow swaggerOAuthFlow;

    public BaseOpenApiBuilder(BuildProperties buildProperties, OAuthFlow swaggerOAuthFlow) {
        this.buildProperties = buildProperties;
        this.swaggerOAuthFlow = swaggerOAuthFlow;
        ModelConverters.getInstance().addConverter((ModelConverter)new EntityModelConverter());
        ModelConverters.getInstance().addConverter((ModelConverter)new CollectionModelConverter());
        ModelConverters.getInstance().addConverter((ModelConverter)new PagedModelConverter());
        ModelConverters.getInstance().addConverter((ModelConverter)new IgnoredTypesModelConverter());
        SwaggerDocUtils.replaceParameterObjectWithClass(Pageable.class, PageableMixin.class);
    }

    public OpenAPI build(String title, String serviceURLPrefix) {
        OpenAPI openAPI = new OpenAPI().info(new Info().title(title).version(this.buildProperties.getVersion()).license(new License().name(String.format("\u00a9 %s-%s %s. All rights reserved", this.buildProperties.get("inceptionYear"), this.buildProperties.get("year"), this.buildProperties.get("organization.name")))).termsOfService(this.buildProperties.get("organization.url"))).components(new Components().addSecuritySchemes("oauth", this.securityScheme()));
        openAPI.addExtension(SERVICE_URL_PREFIX, (Object)serviceURLPrefix);
        return openAPI;
    }

    private SecurityScheme securityScheme() {
        return new SecurityScheme().type(SecurityScheme.Type.OAUTH2).scheme("bearer").bearerFormat("jwt").in(SecurityScheme.In.HEADER).description("Authorizing with SSO").flows(new OAuthFlows().authorizationCode(this.swaggerOAuthFlow));
    }
}

